package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration.BEAN_QUARTZ_SCHEDULER
import com.xebialabs.xlrelease.quartz.release.scheduler.DueSoonNotificationService._
import org.quartz._
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.stereotype.Service

@Service
class DueSoonNotificationService(@Qualifier(BEAN_QUARTZ_SCHEDULER) val scheduler: Scheduler)
  extends BaseNotificationService(serviceName = DUE_SOON_SERVICE,
    jobClazz = classOf[DueSoonNotificationJob],
    defaultTriggerInterval = XlrConfig.getInstance.durations.notifyDueSoonTasksInterval,
    notificationEnabled = XlrConfig.getInstance.features.notifications.dueSoonEnabled)

object DueSoonNotificationService {
  val DUE_SOON_SERVICE = "Due Soon Notification"
}
