package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration.BEAN_QUARTZ_JOB_SCHEDULER
import com.xebialabs.xlrelease.quartz.release.scheduler.UserTokenNotificationService.USER_TOKEN_SERVICE
import org.quartz._
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.stereotype.Service

@Service
class UserTokenNotificationService(@Qualifier(BEAN_QUARTZ_JOB_SCHEDULER) val scheduler: Scheduler)
  extends BaseNotificationService(serviceName = USER_TOKEN_SERVICE,
    jobClazz = classOf[UserTokenNotificationJob],
    defaultTriggerInterval = XlrConfig.getInstance.durations.notifyUserTokenExpiryInterval,
    notificationEnabled = XlrConfig.getInstance.features.notifications.userTokenExpiryEnabled)

object UserTokenNotificationService {
  val USER_TOKEN_SERVICE = "User Token Notification"
}
