package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.upgrade.common.ClassNameToString
import org.quartz.JobBuilder.newJob
import org.quartz.SimpleScheduleBuilder.simpleSchedule
import org.quartz.TriggerBuilder.newTrigger
import org.quartz._

import scala.concurrent.duration.Duration


abstract class BaseNotificationService(val name: String,
                                       jobClazz: Class[_ <: Job],
                                       defaultTriggerInterval: Duration,
                                       val isEnabled: Boolean)
  extends ClassNameToString with QuartzScheduledService {

  private val jobName: String = s"$name JOB".toUpperCase.split(' ').mkString("_")
  private val groupName: String = name.toUpperCase.split(' ').mkString("_")

  def triggerInterval: Duration = defaultTriggerInterval

  def releaseSchedulerService: ReleaseSchedulerService

  private lazy val job: JobDetail = newJob(jobClazz)
    .withDescription(s"$name job")
    .withIdentity(jobName, groupName)
    .storeDurably(true)
    .build()

  private lazy val trigger: SimpleTrigger = newTrigger()
    .withIdentity(jobName, groupName)
    .withDescription(s"Trigger $name jobs")
    .withSchedule(simpleSchedule().withIntervalInMilliseconds(triggerInterval.toMillis).repeatForever().withMisfireHandlingInstructionNowWithRemainingCount())
    .startNow()
    .build()

  override def getJobDetail: JobDetail = job

  override def getTrigger: Trigger = trigger
}
