package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.release.scheduler.DueSoonNotificationService._
import org.springframework.stereotype.Service

@Service
class DueSoonNotificationService(val releaseSchedulerService: ReleaseSchedulerService)
  extends BaseNotificationService(name = DUE_SOON_SERVICE,
    jobClazz = classOf[DueSoonNotificationJob],
    defaultTriggerInterval = XlrConfig.getInstance.durations.notifyDueSoonTasksInterval,
    isEnabled = XlrConfig.getInstance.features.notifications.dueSoonEnabled)

object DueSoonNotificationService {
  val DUE_SOON_SERVICE = "Due Soon Notification"
}
