package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.domain.{PlanItem, Task}
import com.xebialabs.xlrelease.user.User
import grizzled.slf4j.Logging
import org.quartz.JobExecutionContext
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}

class PendingTaskQuartzJob extends PendingPlanItemQuartzJob[Task] with Logging {

  @Autowired
  var releaseActorService: ReleaseActorService = _

  override def execute(context: JobExecutionContext): Unit = {
    val jobKey = context.getJobDetail.getKey
    val taskId = getPlanItemIdFromJobData(context, "Unable to get task id from job data")
    Try {
      taskId.foreach(releaseActorService.startTaskAsync(_, null, User.SYSTEM))
    } match {
      case Failure(ex) => logger.error(s"Unable to start pending task [${taskId.orNull}]", ex)
      case Success(_) => logger.debug(s"Started pending task quartz job [$jobKey]")
    }
  }

  override def supports(planItem: PlanItem): Boolean = planItem.isInstanceOf[Task]

}
