package com.xebialabs.xlrelease.quartz.config

import com.xebialabs.deployit.ServerState
import com.xebialabs.xlrelease.actors.initializer.ActorInitializer
import com.xebialabs.xlrelease.quartz.events.{SchedulerStartedEvent, SchedulerStartingEvent}
import grizzled.slf4j.Logging
import org.quartz.Scheduler
import org.springframework.context.ApplicationEventPublisher

class QuartzInitializer(schedulers: List[Scheduler], eventPublisher: ApplicationEventPublisher)
  extends ActorInitializer with Logging {

  override def initialize(): Unit = {
    if (ServerState.getInstance().getCurrentMode == ServerState.Mode.MAINTENANCE) {
      // Quartz scheduling is disabled so job recovery will also be disabled
      logger.warn("[MAINTENANCE MODE] Scheduled releases and tasks - DISABLED")
      logger.warn("[MAINTENANCE MODE] Polling triggers - DISABLED")
    } else {
      schedulers.foreach { scheduler =>
        try {
          logger.info(s"Starting scheduler '${scheduler.getSchedulerName}'")
          eventPublisher.publishEvent(SchedulerStartingEvent(this, scheduler.getSchedulerName))
          scheduler.start()
          logger.debug(s"Started scheduler '${scheduler.getSchedulerName}'")
          eventPublisher.publishEvent(SchedulerStartedEvent(this, scheduler.getSchedulerName))
        } catch {
          case e: Exception => logger.error(s"Error while starting ${scheduler.getSchedulerName}", e)
        }
      }
    }
  }
}
