package com.xebialabs.xlrelease.quartz.upgrade

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.db.LiquibaseSupport
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration
import com.xebialabs.xlrelease.spring.config.SqlConfiguration.XLR_REPOSITORY_DATA_SOURCE
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_QUARTZ
import com.xebialabs.xlrelease.upgrade.common.{BaseInitializingUpgrade, ClassNameToString}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}

import javax.sql.DataSource

/**
 * https://github.com/quartz-scheduler/quartz/wiki/How-to-Setup-Databases
 * If you already using Liquibase tool in your existing project,
 * then you can simply make a copy and include the liquibase.quartz.init.xml file into your project.
 */
class QuartzDbInitializer extends BaseInitializingUpgrade with ClassNameToString with LiquibaseSupport with Logging {

  @Autowired
  @Qualifier(XLR_REPOSITORY_DATA_SOURCE)
  var dataSource: DataSource = _

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_QUARTZ, "9.6.0#0")

  override def doUpgrade(): Boolean = {
    doWithLiquibase("com/xebialabs/xlrelease/db/liquibase.quartz.init.xml") { liquibase =>
      liquibase.setChangeLogParameter("table_prefix", QuartzConfiguration.QUARTZ_TABLE_PREFIX)
      liquibase.update("")
    }
    true
  }

}
