package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.service.TaskExecutionLogPurgeJob.LOG_PURGE_AGE_KEY
import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

object TaskExecutionLogPurgeJob {
  final val LOG_PURGE_AGE_KEY = "executionLogPurgeAge"
}

@DisallowConcurrentExecution
class TaskExecutionLogPurgeJob @Autowired()(service: TaskExecutionLogPurgeService)
  extends Job with Logging {

  override def execute(context: JobExecutionContext): Unit = {
    logger.debug("Executing task execution log purge job")
    val jobDataMap = context.getMergedJobDataMap
    if (jobDataMap.containsKey(LOG_PURGE_AGE_KEY)) {
      val daysThreshold = jobDataMap.getString(LOG_PURGE_AGE_KEY)
      if (daysThreshold.forall(Character.isDigit)) {
        service.run(daysThreshold.toInt)
      } else {
        logger.warn(s"Cannot execute task execution log purge job as '$daysThreshold' is not a valid retention period")
      }
    } else {
      logger.warn(s"Cannot execute task execution log purge job as $LOG_PURGE_AGE_KEY is missing")
    }

  }
}
