/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.quartz.config;

import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.db.sql.DatabaseInfo;
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration$;
import com.xebialabs.xlrelease.quartz.release.scheduler.ReleaseSchedulerService;
import com.xebialabs.xlrelease.scheduler.RestartableExecutorService;
import com.xebialabs.xlrelease.service.QuartzLifecycleManager;
import com.xebialabs.xlrelease.spring.config.SqlConfiguration;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import grizzled.slf4j.Logging;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.quartz.impl.jdbcjobstore.DB2v8Delegate;
import org.quartz.impl.jdbcjobstore.MSSQLDelegate;
import org.quartz.impl.jdbcjobstore.PostgreSQLDelegate;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.jdbcjobstore.oracle.OracleDelegate;
import org.quartz.spi.JobFactory;
import org.slf4j.Marker;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.quartz.LocalDataSourceJobStore;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;
import scala.Function0;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Configuration
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000e\u001c\u0001\u0019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A1\t\u0001B\u0001B\u0003%A\tC\u0003O\u0001\u0011\u0005q\n\u0003\u0005V\u0001!\u0015\r\u0011\"\u0011W\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015I\b\u0001\"\u0001`\u0011\u0015y\b\u0001\"\u0001q\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!9\u0011q\n\u0001\u0005\n\u0005E\u0003bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003\u0007\u0003A\u0011BAC\u000f\u001d\t\tj\u0007E\u0001\u0003'3aAG\u000e\t\u0002\u0005U\u0005B\u0002(\u0013\t\u0003\t9\nC\u0005\u0002\u001aJ\u0011\r\u0011\"\u0002\u0002\u001c\"A\u00111\u0015\n!\u0002\u001b\ti\nC\u0005\u0002&J\u0011\r\u0011\"\u0002\u0002(\"A\u0011q\u0016\n!\u0002\u001b\tI\u000bC\u0005\u00022J\u0011\r\u0011\"\u0002\u00024\"A\u00111\u0018\n!\u0002\u001b\t)LA\nRk\u0006\u0014HO_\"p]\u001aLw-\u001e:bi&|gN\u0003\u0002\u001d;\u000511m\u001c8gS\u001eT!AH\u0010\u0002\rE,\u0018M\u001d;{\u0015\t\u0001\u0013%A\u0005yYJ,G.Z1tK*\u0011!eI\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001J\u0001\u0004G>l7\u0001A\n\u0004\u0001\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/g5\tqF\u0003\u00021c\u0005)1\u000f\u001c45U*\t!'\u0001\u0005he&T(\u0010\\3e\u0013\t!tFA\u0004M_\u001e<\u0017N\\4\u0002!M\fHnQ8oM&<WO]1uS>t\u0007CA\u001c<\u001b\u0005A$B\u0001\u000f:\u0015\tQt$\u0001\u0004taJLgnZ\u0005\u0003ya\u0012\u0001cU9m\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0013ad'oQ8oM&<\u0007CA B\u001b\u0005\u0001%B\u0001\u000f \u0013\t\u0011\u0005IA\u0005YYJ\u001cuN\u001c4jO\u0006qQM^3oiB+(\r\\5tQ\u0016\u0014\bCA#M\u001b\u00051%BA$I\u0003\u001d\u0019wN\u001c;fqRT!!\u0013&\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aS\u0001\u0004_J<\u0017BA'G\u0005e\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Fm\u0016tG\u000fU;cY&\u001c\b.\u001a:\u0002\rqJg.\u001b;?)\u0011\u0001&k\u0015+\u0011\u0005E\u0003Q\"A\u000e\t\u000bU\"\u0001\u0019\u0001\u001c\t\u000bu\"\u0001\u0019\u0001 \t\u000b\r#\u0001\u0019\u0001#\u0002\r1|wmZ3s+\u00059\u0006C\u0001\u0018Y\u0013\tIvF\u0001\u0004M_\u001e<WM\u001d\u0015\u0003\u000bm\u0003\"\u0001\u000b/\n\u0005uK#!\u0003;sC:\u001c\u0018.\u001a8u\u0003]!(/[4hKJ\u001c6\r[3ek2,'oU3sm&\u001cW\rF\u0001a!\t\tg-D\u0001c\u0015\t\u0019G-A\u0005tG\",G-\u001e7fe*\u0011Q-H\u0001\be\u0016dW-Y:f\u0013\t9'MA\fSK2,\u0017m]3TG\",G-\u001e7feN+'O^5dK\"\u0012a!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u001a\u000b!\"\u00198o_R\fG/[8o\u0013\tq7N\u0001\u0003CK\u0006t\u0017a\u0006;sS\u001e<WM]*dQ\u0016$W\u000f\\3s\r\u0006\u001cGo\u001c:z)\u0005\t\bC\u0001:w\u001b\u0005\u0019(B\u0001\u0010u\u0015\t)\b*\u0001\u0006tG\",G-\u001e7j]\u001eL!a^:\u0003)M\u001b\u0007.\u001a3vY\u0016\u0014h)Y2u_JL()Z1oQ\t9\u0011.A\rrk\u0006\u0014HO\u001f&pEN\u001b\u0007.\u001a3vY\u0016\u00148+\u001a:wS\u000e,\u0007F\u0001\u0005jQ\tAA\u0010\u0005\u0002k{&\u0011ap\u001b\u0002\b!JLW.\u0019:z\u0003e\tX/\u0019:uu*{'mU2iK\u0012,H.\u001a:GC\u000e$xN]=)\u0005%I\u0007FA\u0005}\u0003Y\tX/\u0019:uu2Kg-Z2zG2,W*\u00198bO\u0016\u0014HCAA\u0005!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\b?\u000591/\u001a:wS\u000e,\u0017\u0002BA\n\u0003\u001b\u0011a#U;beRTH*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d\u0015\u0003\u0015%\f!B[8c\r\u0006\u001cGo\u001c:z)\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u0015RBAA\u0010\u0015\u0011\t\t#a\t\u0002\u0007M\u0004\u0018N\u0003\u0002\u001f\u0015&!\u0011qEA\u0010\u0005)QuN\u0019$bGR|'/\u001f\u0015\u0003\u0017%\f\u0001#];beRT\bK]8qKJ$\u0018.Z:\u0015\u0005\u0005=\u0002\u0003BA\u0019\u0003wi!!a\r\u000b\t\u0005U\u0012qG\u0001\u0005kRLGN\u0003\u0002\u0002:\u0005!!.\u0019<b\u0013\u0011\ti$a\r\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u000b\u0002\rS\u0006Ab/\u00197jI\u0006$X-U;beRT\bK]8qKJ$\u0018.Z:\u0015\t\u0005\u0015\u00131\n\t\u0004Q\u0005\u001d\u0013bAA%S\t!QK\\5u\u0011\u001d\ti%\u0004a\u0001\u0003_\tQ\u0001\u001d:paN\fac\u0019:fCR,7k\u00195fIVdWM\u001d$bGR|'/\u001f\u000b\u0006c\u0006M\u0013Q\u000e\u0005\b\u0003+r\u0001\u0019AA,\u00035\u00198\r[3ek2,'OT1nKB!\u0011\u0011LA4\u001d\u0011\tY&a\u0019\u0011\u0007\u0005u\u0013&\u0004\u0002\u0002`)\u0019\u0011\u0011M\u0013\u0002\rq\u0012xn\u001c;?\u0013\r\t)'K\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00141\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015\u0014\u0006C\u0004\u0002p9\u0001\r!!\u001d\u0002\u0019Q\f7o[#yK\u000e,Ho\u001c:\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kRA!a\u001e\u00024\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005m\u0014Q\u000f\u0002\t\u000bb,7-\u001e;pe\u0006\t2m\u001c8gS\u001e,(/\u001a&pEN#xN]3\u0015\t\u0005\u0015\u0013\u0011\u0011\u0005\b\u0003\u001bz\u0001\u0019AA\u0018\u0003M\u0019wN\u001c4jOV\u0014Xm\u00117vgR,'/\u001b8h)\u0011\t)%a\"\t\u000f\u00055\u0003\u00031\u0001\u00020!\u001a\u0001!a#\u0011\u0007)\fi)C\u0002\u0002\u0010.\u0014QbQ8oM&<WO]1uS>t\u0017aE)vCJ$(pQ8oM&<WO]1uS>t\u0007CA)\u0013'\t\u0011r\u0005\u0006\u0002\u0002\u0014\u00061BKU%H\u000f\u0016\u0013vlU\"I\u000b\u0012+F*\u0012*`\u001d\u0006kU)\u0006\u0002\u0002\u001e>\u0011\u0011qT\u0011\u0003\u0003C\u000b1\u0003\u001f7s)JLwmZ3s'\u000eDW\rZ;mKJ\fq\u0003\u0016*J\u000f\u001e+%kX*D\u0011\u0016#U\u000bT#S?:\u000bU*\u0012\u0011\u0002+E+\u0016I\u0015+[?N\u001b\u0005*\u0012#V\u0019\u0016\u0013vLT!N\u000bV\u0011\u0011\u0011V\b\u0003\u0003W\u000b#!!,\u0002%ad'/U;beRT8k\u00195fIVdWM]\u0001\u0017#V\u000b%\u000b\u0016.`'\u000eCU\tR+M\u000bJ{f*Q'FA\u0005\u0019\u0012+V!S)j{F+\u0011\"M\u000b~\u0003&+\u0012$J1V\u0011\u0011QW\b\u0003\u0003o\u000b#!!/\u0002\u0005E{\u0016\u0001F)V\u0003J#&l\u0018+B\u00052+u\f\u0015*F\r&C\u0006\u0005")
public class QuartzConfiguration
implements Logging {
    private transient Logger logger;
    private final SqlConfiguration sqlConfiguration;
    private final XlrConfig xlrConfig;
    private final ApplicationEventPublisher eventPublisher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient byte bitmap$trans$0;

    public static String QUARTZ_TABLE_PREFIX() {
        return QuartzConfiguration$.MODULE$.QUARTZ_TABLE_PREFIX();
    }

    public static String QUARTZ_SCHEDULER_NAME() {
        return QuartzConfiguration$.MODULE$.QUARTZ_SCHEDULER_NAME();
    }

    public static String TRIGGER_SCHEDULER_NAME() {
        return QuartzConfiguration$.MODULE$.TRIGGER_SCHEDULER_NAME();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        QuartzConfiguration quartzConfiguration = this;
        synchronized (quartzConfiguration) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private Logger logger$lzycompute() {
        QuartzConfiguration quartzConfiguration = this;
        synchronized (quartzConfiguration) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.logger = Logger$.MODULE$.apply(QuartzConfiguration.class);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Bean
    public ReleaseSchedulerService triggerSchedulerService() {
        return new ReleaseSchedulerService(this.triggerSchedulerFactory());
    }

    @Bean
    public SchedulerFactoryBean triggerSchedulerFactory() {
        return this.createSchedulerFactory("xlrTriggerScheduler", this.xlrConfig.executors().releaseTrigger().pool());
    }

    @Bean
    @Primary
    public ReleaseSchedulerService quartzJobSchedulerService() {
        return new ReleaseSchedulerService(this.quartzJobSchedulerFactory());
    }

    @Bean
    @Primary
    public SchedulerFactoryBean quartzJobSchedulerFactory() {
        return this.createSchedulerFactory("xlrQuartzScheduler", this.xlrConfig.executors().quartzJobExecutor().pool());
    }

    @Bean
    public QuartzLifecycleManager quartzLifecycleManager() {
        .colon.colon schedulers = new .colon.colon((Object)this.triggerSchedulerFactory(), (List)new .colon.colon((Object)this.quartzJobSchedulerFactory(), (List)Nil$.MODULE$));
        .colon.colon executors = new .colon.colon((Object)((RestartableExecutorService)this.xlrConfig.executors().releaseTrigger().pool()), (List)new .colon.colon((Object)((RestartableExecutorService)this.xlrConfig.executors().quartzJobExecutor().pool()), (List)Nil$.MODULE$));
        return new QuartzLifecycleManager((List<SchedulerFactoryBean>)schedulers, (List<RestartableExecutorService>)executors, this.eventPublisher);
    }

    @Bean
    public JobFactory jobFactory() {
        return new SpringBeanJobFactory();
    }

    @Bean
    public Properties quartzProperties() {
        Properties properties;
        PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
        propertiesFactoryBean.setLocation((Resource)new ClassPathResource("/quartz.properties"));
        try {
            propertiesFactoryBean.afterPropertiesSet();
            properties = new Properties(propertiesFactoryBean.getObject());
        }
        catch (IOException e) {
            this.logger().debug((Function0 & Serializable)() -> "Cannot load quartz.properties.");
            properties = new Properties();
        }
        Properties props = properties;
        this.configureJobStore(props);
        this.configureClustering(props);
        this.validateQuartzProperties(props);
        return props;
    }

    private void validateQuartzProperties(Properties props) {
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!(value instanceof String)) {
                throw new IllegalStateException("Quartz property '" + key + "' value should be string");
            }
        }));
    }

    private SchedulerFactoryBean createSchedulerFactory(String schedulerName, Executor taskExecutor) {
        SchedulerFactoryBean quartzScheduler = new SchedulerFactoryBean();
        quartzScheduler.setDataSource(this.sqlConfiguration.xlrRepositoryDataSourceProxy());
        quartzScheduler.setTransactionManager(this.sqlConfiguration.xlrRepositoryTransactionManager());
        quartzScheduler.setOverwriteExistingJobs(true);
        quartzScheduler.setAutoStartup(false);
        quartzScheduler.setSchedulerName(schedulerName);
        quartzScheduler.setTaskExecutor(taskExecutor);
        quartzScheduler.setJobFactory(this.jobFactory());
        quartzScheduler.setWaitForJobsToCompleteOnShutdown(true);
        quartzScheduler.setQuartzProperties(this.quartzProperties());
        return quartzScheduler;
    }

    private void configureJobStore(Properties props) {
        String string;
        props.put("org.quartz.jobStore.useProperties", Boolean.TRUE.toString());
        props.put("org.quartz.jobStore.class", LocalDataSourceJobStore.class.getCanonicalName());
        props.put("org.quartz.jobStore.tablePrefix", "Q_");
        DatabaseInfo databaseInfo = this.sqlConfiguration.xlrDbInfo();
        if (databaseInfo instanceof DatabaseInfo.Db2) {
            string = DB2v8Delegate.class.getCanonicalName();
        } else if (databaseInfo instanceof DatabaseInfo.Oracle) {
            string = OracleDelegate.class.getCanonicalName();
        } else if (databaseInfo instanceof DatabaseInfo.MsSqlServer) {
            props.put("org.quartz.jobStore.acquireTriggersWithinLock", Boolean.TRUE.toString());
            string = MSSQLDelegate.class.getCanonicalName();
        } else {
            string = databaseInfo instanceof DatabaseInfo.PostgreSql ? PostgreSQLDelegate.class.getCanonicalName() : StdJDBCDelegate.class.getCanonicalName();
        }
        String driverDelegateClass = string;
        props.put("org.quartz.jobStore.driverDelegateClass", driverDelegateClass);
    }

    private void configureClustering(Properties props) {
        Boolean FALSE = BoxesRunTime.boxToBoolean((boolean)false);
        ClusterMode clusterMode = this.xlrConfig.cluster().mode();
        ClusterMode.Standalone$ standalone$ = ClusterMode.Standalone$.MODULE$;
        boolean isClustered = clusterMode == null ? standalone$ != null : !clusterMode.equals(standalone$);
        props.put("org.quartz.jobStore.isClustered", Boolean.toString(isClustered));
        if (isClustered) {
            props.put("org.quartz.scheduler.instanceId", "AUTO");
            props.put("org.quartz.jobStore.misfireThreshold", "60000");
            v1 = props.put("org.quartz.jobStore.clusterCheckinInterval", "20000");
        } else {
            v1 = BoxedUnit.UNIT;
        }
        props.put("org.quartz.scheduler.rmi.export", FALSE.toString());
        props.put("org.quartz.scheduler.rmi.proxy", FALSE.toString());
    }

    public QuartzConfiguration(SqlConfiguration sqlConfiguration, XlrConfig xlrConfig, ApplicationEventPublisher eventPublisher) {
        this.sqlConfiguration = sqlConfiguration;
        this.xlrConfig = xlrConfig;
        this.eventPublisher = eventPublisher;
        Logging.$init$((Logging)this);
    }
}

