package com.xebialabs.xlrelease.scheduler

import com.xebialabs.xlplatform.cluster.ClusterMode.Full
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.scheduler.service.JobCleanupService
import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

@DisallowConcurrentExecution
class ScheduledTaskRecoveryJob extends Job with Logging {

  @Autowired
  var jobCleanupService: JobCleanupService = _

  override def execute(context: JobExecutionContext): Unit = {
    logger.debug("Executing scheduled task recovery job")
    jobCleanupService.detectStaleReservedJobs()

    XlrConfig.getInstance.clusterMode match {
      // we need to check once more here, because eventually job may be
      // already in the database, when configuration is switched from cluster to
      // standalone mode, and job will be executed before we manage to delete it
      // in ScheduledTaskRecovery component
      case Full => jobCleanupService.detectAbandonedTasks()
      case _ => logger.debug(s"Skipping ${classOf[ScheduledTaskRecoveryJob].getName} because it only runs in a cluster mode")
    }
  }
}
