package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.service.UserTokenService
import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

@DisallowConcurrentExecution
class UserTokenNotificationJob extends Job with Logging {

  @Autowired
  var userTokenService: UserTokenService = _

  override def execute(context: JobExecutionContext): Unit = {
    logger.debug("Executing user token notification job")
    userTokenService.notifyTokensAboutToExpire()
  }

}
