package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.domain.PlanItem
import com.xebialabs.xlrelease.quartz.release.scheduler.QuartzPendingPlanItemScheduledJobService.JOB_DATA_KEY
import grizzled.slf4j.Logging
import org.quartz.{Job, JobExecutionContext}

import scala.jdk.CollectionConverters._
import scala.util.Try

trait PendingPlanItemQuartzJob[A <: PlanItem] extends Job { self: Logging =>

  def supports(planItem: PlanItem): Boolean

  def getPlanItemIdFromJobData(context: JobExecutionContext, errorMsg: String): Option[String]  = {
    Try(getPlanItemIdFromJobData(context)).recover {
      case ex =>
        logger.error(errorMsg, ex)
        None
    }.toOption.flatten
  }

  private def getPlanItemIdFromJobData(context: JobExecutionContext): Option[String] = {
    val jobDataMap = context.getJobDetail.getJobDataMap
    if (jobDataMap.containsKey(JOB_DATA_KEY)) {
      Option(jobDataMap.getString(JOB_DATA_KEY))
    } else {
      // DANGER. VERY HACKY SOLUTION. SHOULD BE REMOVED AFTER 2025.
      // With D-25194, quartz job store serializes the data as string. Before that, data was serialized using java serializer.
      // Due to this, customers who upgraded to new versions and had prior data were facing issue with scheduled release and task for existing data before upgrade.
      // We are trying to hack around and find release id or task id to avoid writing any upgrader or doing extra database calls.
      // The following block is only used if you have prior data in the database. It is not at all used for any jobs created after upgrade.
      val maybeKey = jobDataMap.keySet().asScala.find(_.contains(JOB_DATA_KEY))
      maybeKey.map { v =>
        val sanitizedKey = v.replaceAll("[^A-Za-z0-9/]", "")
        val planItemId = sanitizedKey.substring(sanitizedKey.indexOf("Applications"), sanitizedKey.length - 1)
        planItemId
      }
    }
  }
}
