package com.xebialabs.xlrelease.service

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.security.RoleService
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator
import com.xebialabs.xlrelease.domain.group.ReleaseGroup
import com.xebialabs.xlrelease.domain.{CiWithInternalMetadata, Team}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class ReleaseGroupSecurityDecorator @Autowired()(roleService: RoleService,
                                                 teamService: TeamService)
  extends EffectiveSecurityDecorator(roleService, teamService) {

  override def isApplicableTo(ci: ConfigurationItem): Boolean = ci.isInstanceOf[ReleaseGroup]

  override def getEffectiveTeams(container: CiWithInternalMetadata): Seq[Team] = {
    container match {
      case releaseGroup: ReleaseGroup =>
        teamService.getEffectiveTeams(releaseGroup.getFolderId).asScala.toSeq
      case _ => Seq.empty[Team]
    }
  }
}
