package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.api.v1.forms.{ReleaseGroupFilters, ReleaseGroupOrderMode}
import com.xebialabs.xlrelease.domain.group.ReleaseGroup
import com.xebialabs.xlrelease.repository.Ids.isNullId
import com.xebialabs.xlrelease.repository.sql.persistence.CiIdWithTitle


trait ReleaseGroupRepository {
  def read(groupId: String): ReleaseGroup

  def search(filters: ReleaseGroupFilters, page: Page, orderBy: ReleaseGroupOrderMode,
             principals: Iterable[String], roleIds: Iterable[String]): Seq[ReleaseGroup]

  def create(releaseGroup: ReleaseGroup): Unit

  def update(releaseGroup: ReleaseGroup): Unit

  def createOrUpdate(releaseGroup: ReleaseGroup): Unit = {
    if (!isNullId(releaseGroup.getId) && exists(releaseGroup.getId)) {
      update(releaseGroup)
    } else {
      create(releaseGroup)
    }
  }

  def exists(groupId: String): Boolean

  def delete(groupId: String): Unit

  def findGroupsReferencingReleaseId(releaseId: String): Seq[String]

  def findActiveGroupsReferencingFolderId(folderId: String): Seq[CiIdWithTitle]

  def findFolderId(groupId: String): String
}
