/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseGroupActorService;
import com.xebialabs.xlrelease.api.v1.ReleaseGroupApi;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupFilters;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupOrderMode;
import com.xebialabs.xlrelease.api.v1.views.ReleaseGroupTimeline;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseGroupService;
import io.micrometer.core.annotation.Timed;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ReleaseGroupApiImpl
implements ReleaseGroupApi {
    private final ReleaseGroupActorService releaseGroupActorService;
    private final ReleaseGroupService releaseGroupService;
    private final PermissionChecker permissions;

    @Autowired
    public ReleaseGroupApiImpl(ReleaseGroupActorService releaseGroupActorService, ReleaseGroupService releaseGroupService, PermissionChecker permissions) {
        this.releaseGroupActorService = releaseGroupActorService;
        this.releaseGroupService = releaseGroupService;
        this.permissions = permissions;
    }

    @Timed
    public ReleaseGroup getGroup(String groupId) {
        this.checkPermissions(groupId, XLReleasePermissions.VIEW_RELEASE_GROUP);
        return this.releaseGroupService.getGroup(groupId);
    }

    @Timed
    public void deleteGroup(String groupId) {
        this.checkPermissions(groupId, XLReleasePermissions.EDIT_RELEASE_GROUP);
        this.releaseGroupActorService.deleteGroup(groupId);
    }

    @Timed
    public ReleaseGroup createGroup(ReleaseGroup releaseGroup) {
        Checks.checkNotNull((Object)releaseGroup.getFolderId(), (String)"folderId");
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE_GROUP, releaseGroup.getFolderId());
        return this.releaseGroupActorService.createGroup(releaseGroup);
    }

    @Timed
    public ReleaseGroup updateGroup(String groupId, ReleaseGroup releaseGroup) {
        releaseGroup.setId(groupId);
        this.checkPermissions(groupId, XLReleasePermissions.EDIT_RELEASE_GROUP);
        return this.releaseGroupActorService.updateGroup(releaseGroup);
    }

    @Timed
    public List<String> getMembers(String groupId) {
        Checks.checkNotNull((Object)groupId, (String)"groupId");
        this.checkPermissions(groupId, XLReleasePermissions.VIEW_RELEASE_GROUP);
        return new ArrayList<String>(this.releaseGroupService.getGroup(groupId).getReleaseIds());
    }

    @Timed
    public void addMembersToGroup(String groupId, List<String> memberIds) {
        Checks.checkNotNull((Object)groupId, (String)"groupId");
        Checks.checkNotNull(memberIds, (String)"memberIds");
        this.checkPermissions(groupId, XLReleasePermissions.EDIT_RELEASE_GROUP);
        this.releaseGroupActorService.addMembersToGroup(groupId, memberIds);
    }

    @Timed
    public void removeMembersFromGroup(String groupId, List<String> memberIds) {
        Checks.checkNotNull((Object)groupId, (String)"groupId");
        Checks.checkNotNull(memberIds, (String)"memberIds");
        this.checkPermissions(groupId, XLReleasePermissions.EDIT_RELEASE_GROUP);
        this.releaseGroupActorService.removeMembersFromGroup(groupId, memberIds);
    }

    @Timed
    public List<ReleaseGroup> searchGroups(ReleaseGroupFilters groupFilters, Long page, Long resultsPerPage, ReleaseGroupOrderMode orderBy) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        if (null == groupFilters) {
            groupFilters = new ReleaseGroupFilters();
        }
        return this.releaseGroupService.search(groupFilters, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultsPerPage), Optional.empty()), orderBy);
    }

    @Timed
    public ReleaseGroupTimeline getReleaseGroupTimeline(String groupId) {
        this.checkPermissions(groupId, XLReleasePermissions.VIEW_RELEASE_GROUP);
        return this.releaseGroupService.getTimeline(groupId, DateTime.now());
    }

    private void checkPermissions(String groupId, Permission permission) {
        String folderId = this.releaseGroupService.getFolderId(groupId);
        this.permissions.check(permission, folderId);
    }
}

