package com.xebialabs.xlrelease.reports.job.impl

import akka.actor.{ActorRef, Props}
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.actors.initializer.ActorInitializer
import com.xebialabs.xlrelease.config.XlrConfig
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.concurrent.{Await, Promise}

@Component
class ReportJobDelegateActorHolder @Autowired()(xlrConfig: XlrConfig) {

  private val actorPromise = Promise[ActorRef]()

  def actorRef(): ActorRef = {
    Await.result(actorPromise.future, xlrConfig.timeouts.systemInitialization)
  }

  def resolveActorRef(actorRef: ActorRef): Unit = {
    actorPromise.success(actorRef)
  }
}

trait ReportJobDelegateActorInitializer extends ActorInitializer {
  def reportJobDelegateActorHolder: ReportJobDelegateActorHolder

  override def initialize(): Unit = {
    reportJobDelegateActorHolder.resolveActorRef(createActor())
  }

  protected def createActor(): ActorRef
}

object ReportJobDelegateActorInitializer {

  class NonClusterReportJobDelegateActorInitializer(systemHolder: ActorSystemHolder,
                                                    val reportJobDelegateActorHolder: ReportJobDelegateActorHolder,
                                                    val xlrConfig: XlrConfig,
                                                   ) extends ReportJobDelegateActorInitializer {

    override protected def createActor(): ActorRef = {
      systemHolder.actorSystem.actorOf(Props(new ReportJobDelegateActor()))
    }

  }

  class ClusteredReportJobDelegateActorInitializer(systemHolder: ActorSystemHolder,
                                                   val reportJobDelegateActorHolder: ReportJobDelegateActorHolder,
                                                   val xlrConfig: XlrConfig,
                                                  ) extends ReportJobDelegateActorInitializer {

    override protected def createActor(): ActorRef = {
      systemHolder.actorSystem.actorOf(Props(new ClusteredReportJobDelegateActor()))
    }

  }

}
