package com.xebialabs.xlrelease.reports.job.impl.cleanup

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.config.QuartzConfiguration.BEAN_QUARTZ_SCHEDULER
import com.xebialabs.xlrelease.quartz.events.SchedulerStartedEvent
import grizzled.slf4j.Logging
import org.quartz.JobBuilder.newJob
import org.quartz.SimpleScheduleBuilder.simpleSchedule
import org.quartz.TriggerBuilder.newTrigger
import org.quartz.{JobDetail, Scheduler, SimpleTrigger}
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.context.event
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
class ReportCleanerSchedulerService @Autowired()(@Qualifier(BEAN_QUARTZ_SCHEDULER) scheduler: Scheduler, xlrConfig: XlrConfig) extends Logging {

  val jobName = "REPORT_CLEANER_JOB"
  val groupName = "REPORT_CLEANER"
  val cleanUpInterval: Long = xlrConfig.reporting.engine.cleanUpInterval

  lazy val job: JobDetail = newJob(classOf[ReportCleanerJob])
    .withDescription(s"Report Cleanup jobs")
    .withIdentity(jobName, groupName)
    .build()

  lazy val trigger: SimpleTrigger = newTrigger()
    .withIdentity(jobName, groupName)
    .withDescription(s"Trigger ReportCleaner jobs")
    .withSchedule(simpleSchedule().withIntervalInMilliseconds(cleanUpInterval).repeatForever().withMisfireHandlingInstructionNowWithRemainingCount())
    .startNow()
    .build()

  private def schedule(): Unit = {
    logger.debug(s"Scheduled ReportCleaner service")
    if (scheduler.checkExists(trigger.getKey)) {
      scheduler.rescheduleJob(trigger.getKey, trigger)
    } else {
      scheduler.scheduleJob(job, Set(trigger).asJava, true)
    }
  }

  @event.EventListener
  def onStartup(event: SchedulerStartedEvent): Unit = {
    try {
      schedule()
    } catch {
      case e: Exception => logger.error(s"Error while starting ReportCleaner service", e)
    }
  }
}
