/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.audit;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlplatform.io.ZipUtils$;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.utils.ReleaseIdInDatabase;
import com.xebialabs.xlrelease.planner.PlannerReleaseItem;
import com.xebialabs.xlrelease.reports.audit.InstanceData;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReportComponent$;
import com.xebialabs.xlrelease.reports.audit.ReportFilterMapper;
import com.xebialabs.xlrelease.reports.audit.package$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$EitherOps$;
import com.xebialabs.xlrelease.reports.excel.AuditReport;
import com.xebialabs.xlrelease.reports.excel.AuditReport$;
import com.xebialabs.xlrelease.reports.excel.ExcelSheetWriter;
import com.xebialabs.xlrelease.reports.excel.MultiReleaseAuditReport;
import com.xebialabs.xlrelease.reports.excel.MultiReleaseAuditReport$;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.reports.job.api.ReportJobProgressMonitor;
import com.xebialabs.xlrelease.reports.job.api.ReportJobRunContext;
import com.xebialabs.xlrelease.reports.service.ReportsService;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.udm.reporting.AuditReportRequest;
import com.xebialabs.xlrelease.views.converters.ReleaseViewConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.joda.time.Duration;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Success;
import scala.util.Try;

@Service
@ScalaSignature(bytes="\u0006\u0005\r\u0015u!\u0002#F\u0011\u0003\u0001f!\u0002*F\u0011\u0003\u0019\u0006\"\u0002.\u0002\t\u0003Y\u0006b\u0002/\u0002\u0005\u0004%\t!\u0018\u0005\u0007M\u0006\u0001\u000b\u0011\u00020\t\u000f\u001d\f!\u0019!C\u0001;\"1\u0001.\u0001Q\u0001\nyCq![\u0001C\u0002\u0013\u0005Q\f\u0003\u0004k\u0003\u0001\u0006IA\u0018\u0005\bW\u0006\u0011\r\u0011\"\u0001^\u0011\u0019a\u0017\u0001)A\u0005=\"9Q.\u0001b\u0001\n\u0003i\u0006B\u00028\u0002A\u0003%a\fC\u0004p\u0003\t\u0007I\u0011A/\t\rA\f\u0001\u0015!\u0003_\u0011\u001d\t\u0018A1A\u0005\u0002uCaA]\u0001!\u0002\u0013q\u0006bB:\u0002\u0005\u0004%\t\u0001\u001e\u0005\u0007w\u0006\u0001\u000b\u0011B;\t\u000fq\f!\u0019!C\u0001{\"9\u00111A\u0001!\u0002\u0013q\b\u0002CA\u0003\u0003\t\u0007I\u0011A?\t\u000f\u0005\u001d\u0011\u0001)A\u0005}\"I\u0011\u0011B\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003C\t\u0001\u0015!\u0003\u0002\u000e!9\u00111E\u0001\u0005\u0002\u0005\u0015bABA \u0003\u0001\u000b\t\u0005\u0003\u0006\u0002\\i\u0011)\u001a!C\u0001\u0003;B!\"a\u0018\u001b\u0005#\u0005\u000b\u0011BA\u0014\u0011)\t\tG\u0007BK\u0002\u0013\u0005\u00111\r\u0005\u000b\u0003cR\"\u0011#Q\u0001\n\u0005\u0015\u0004BCA:5\tU\r\u0011\"\u0001\u0002v!Q\u0011\u0011\u0012\u000e\u0003\u0012\u0003\u0006I!a\u001e\t\riSB\u0011AAF\u0011%\t9JGA\u0001\n\u0003\tI\nC\u0005\u0002\"j\t\n\u0011\"\u0001\u0002$\"I\u0011\u0011\u0018\u000e\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u007fS\u0012\u0013!C\u0001\u0003\u0003D\u0001\"!2\u001b\u0003\u0003%\t%\u0018\u0005\t\u0003\u000fT\u0012\u0011!C\u0001{\"I\u0011\u0011\u001a\u000e\u0002\u0002\u0013\u0005\u00111\u001a\u0005\n\u0003/T\u0012\u0011!C!\u00033D\u0011\"a:\u001b\u0003\u0003%\t!!;\t\u0013\u0005M($!A\u0005B\u0005U\b\"CA}5\u0005\u0005I\u0011IA~\u0011%\tiPGA\u0001\n\u0003\ny\u0010C\u0005\u0003\u0002i\t\t\u0011\"\u0011\u0003\u0004\u001dI!qA\u0001\u0002\u0002#\u0005!\u0011\u0002\u0004\n\u0003\u007f\t\u0011\u0011!E\u0001\u0005\u0017AaA\u0017\u0019\u0005\u0002\t\r\u0002\"CA\u007fa\u0005\u0005IQIA\u0000\u0011%\u0011)\u0003MA\u0001\n\u0003\u00139\u0003C\u0005\u00030A\n\t\u0011\"!\u00032!I!1\t\u0019\u0002\u0002\u0013%!Q\t\u0004\u0006%\u0016\u0003!Q\n\u0005\u000b\u0005?2$\u0011!Q\u0001\n\t\u0005\u0004B\u0003B7m\t\u0005\t\u0015!\u0003\u0003p!Q!\u0011\u0010\u001c\u0003\u0002\u0003\u0006IAa\u001f\t\u0015\t\u0005eG!A!\u0002\u0013\u0011\u0019\t\u0003\u0006\u0003\u0010Z\u0012\t\u0011)A\u0005\u0005#C!B!)7\u0005\u0003\u0005\u000b\u0011\u0002BR\u0011)\u0011IK\u000eB\u0001B\u0003%!1\u0016\u0005\u00075Z\"\tA!-\t\u000f\t}g\u0007\"\u0001\u0003b\"91Q\u0001\u001c\u0005\n\r\u001d\u0001bBB,m\u0011%1\u0011\f\u0005\b\u0007C2D\u0011AB2\u0011\u001d\u00199G\u000eC\u0005\u0007S\n\u0001%T;mi&\u0014V\r\\3bg\u0016\fU\u000fZ5u%\u0016\u0004xN\u001d;D_6\u0004xN\\3oi*\u0011aiR\u0001\u0006CV$\u0017\u000e\u001e\u0006\u0003\u0011&\u000bqA]3q_J$8O\u0003\u0002K\u0017\u0006I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u00196\u000b\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00039\u000b1aY8n\u0007\u0001\u0001\"!U\u0001\u000e\u0003\u0015\u0013\u0001%T;mi&\u0014V\r\\3bg\u0016\fU\u000fZ5u%\u0016\u0004xN\u001d;D_6\u0004xN\\3oiN\u0011\u0011\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0002/\u0006)1oY1mC&\u0011\u0011L\u0016\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0001\u0016aD#Y\u0007\u0016cu,\u0012-U\u000b:\u001b\u0016j\u0014(\u0016\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\t1\fgn\u001a\u0006\u0002G\u0006!!.\u0019<b\u0013\t)\u0007M\u0001\u0004TiJLgnZ\u0001\u0011\u000bb\u001bU\tT0F1R+ejU%P\u001d\u0002\n!#\u0012-D\u000b2{6i\u0014(U\u000b:#v\fV-Q\u000b\u0006\u0019R\tW\"F\u0019~\u001buJ\u0014+F\u001dR{F+\u0017)FA\u0005i!,\u0013)`\u000bb#VIT*J\u001f:\u000baBW%Q?\u0016CF+\u0012(T\u0013>s\u0005%\u0001\u0007N\u0003N#VIU0U\u0013RcU)A\u0007N\u0003N#VIU0U\u0013RcU\tI\u0001\u0017\u001b\u0006\u001bF+\u0012*`)&#F*R0T\u000bB\u000b%+\u0011+P%\u00069R*Q*U\u000bJ{F+\u0013+M\u000b~\u001bV\tU!S\u0003R{%\u000bI\u0001\u0017'&su\tT#`)&#F*R0T\u000bB\u000b%+\u0011+P%\u000692+\u0013(H\u0019\u0016{F+\u0013+M\u000b~\u001bV\tU!S\u0003R{%\u000bI\u0001\u0013'&su\tT#`%\u0016\u0003vJ\u0015+T?\u0012K%+A\nT\u0013:;E*R0S\u000bB{%\u000bV*`\t&\u0013\u0006%\u0001\nE\u0003R+E+S'F?\u001a{%+T!U)\u0016\u0013V#A;\u0011\u0005YLX\"A<\u000b\u0005a\u0014\u0017\u0001\u0002;fqRL!A_<\u0003!MKW\u000e\u001d7f\t\u0006$XMR8s[\u0006$\u0018a\u0005#B)\u0016#\u0016*T#`\r>\u0013V*\u0011+U\u000bJ\u0003\u0013a\u0005$J\u0019\u0016s\u0015)T#`\u001b\u0006Cv\fT#O\u000fRCU#\u0001@\u0011\u0005U{\u0018bAA\u0001-\n\u0019\u0011J\u001c;\u0002)\u0019KE*\u0012(B\u001b\u0016{V*\u0011-`\u0019\u0016su\t\u0016%!\u0003E!UIR!V\u0019R{\u0006+Q$F?NK%,R\u0001\u0013\t\u00163\u0015)\u0016'U?B\u000bu)R0T\u0013j+\u0005%\u0001\nE\u000b\u001a\u000bU\u000b\u0014+`\u001fJ#UIU0N\u001f\u0012+UCAA\u0007!\u0011\ty!!\b\u000e\u0005\u0005E!\u0002BA\n\u0003+\tQAZ8s[NTA!a\u0006\u0002\u001a\u0005\u0011a/\r\u0006\u0004\u00037I\u0015aA1qS&!\u0011qDA\t\u0005A\u0011V\r\\3bg\u0016|%\u000fZ3s\u001b>$W-A\nE\u000b\u001a\u000bU\u000b\u0014+`\u001fJ#UIU0N\u001f\u0012+\u0005%\u0001\ttC:LG/\u001b>f\r&dWM\\1nKR!\u0011qEA\u001e!\u0011\tI#a\u000e\u000f\t\u0005-\u00121\u0007\t\u0004\u0003[1VBAA\u0018\u0015\r\t\tdT\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Ub+\u0001\u0004Qe\u0016$WMZ\u0005\u0004K\u0006e\"bAA\u001b-\"9\u0011QH\rA\u0002\u0005\u001d\u0012\u0001\u00034jY\u0016t\u0017-\\3\u0003\t\u0011\u000bG/Y\n\u00075Q\u000b\u0019%!\u0013\u0011\u0007U\u000b)%C\u0002\u0002HY\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002L\u0005Uc\u0002BA'\u0003#rA!!\f\u0002P%\tq+C\u0002\u0002TY\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002X\u0005e#\u0001D*fe&\fG.\u001b>bE2,'bAA*-\u0006Yq-\u001a8fe\u0006$X\r\u001a\"z+\t\t9#\u0001\u0007hK:,'/\u0019;fI\nK\b%A\u0006hK:,'/\u0019;fI>sWCAA3!\u0011\t9'!\u001c\u000e\u0005\u0005%$bAA6E\u0006!Q\u000f^5m\u0013\u0011\ty'!\u001b\u0003\t\u0011\u000bG/Z\u0001\rO\u0016tWM]1uK\u0012|e\u000eI\u0001\u000ee\u0016\u0004xN\u001d;GS2$XM]:\u0016\u0005\u0005]\u0004CBA&\u0003s\ni(\u0003\u0003\u0002|\u0005e#aA*fcB!\u0011qPAC\u001b\t\t\tIC\u0002\u0002\u0004\u001e\u000bqAZ5mi\u0016\u00148/\u0003\u0003\u0002\b\u0006\u0005%\u0001\u0004*fa>\u0014HOR5mi\u0016\u0014\u0018A\u0004:fa>\u0014HOR5mi\u0016\u00148\u000f\t\u000b\t\u0003\u001b\u000b\t*a%\u0002\u0016B\u0019\u0011q\u0012\u000e\u000e\u0003\u0005Aq!a\u0017\"\u0001\u0004\t9\u0003C\u0004\u0002b\u0005\u0002\r!!\u001a\t\u000f\u0005M\u0014\u00051\u0001\u0002x\u0005!1m\u001c9z)!\ti)a'\u0002\u001e\u0006}\u0005\"CA.EA\u0005\t\u0019AA\u0014\u0011%\t\tG\tI\u0001\u0002\u0004\t)\u0007C\u0005\u0002t\t\u0002\n\u00111\u0001\u0002x\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAASU\u0011\t9#a*,\u0005\u0005%\u0006\u0003BAV\u0003kk!!!,\u000b\t\u0005=\u0016\u0011W\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a-W\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\u000biKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002>*\"\u0011QMAT\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a1+\t\u0005]\u0014qU\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QZAj!\r)\u0016qZ\u0005\u0004\u0003#4&aA!os\"A\u0011Q\u001b\u0015\u0002\u0002\u0003\u0007a0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00037\u0004b!!8\u0002d\u00065WBAAp\u0015\r\t\tOV\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAs\u0003?\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111^Ay!\r)\u0016Q^\u0005\u0004\u0003_4&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003+T\u0013\u0011!a\u0001\u0003\u001b\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019a,a>\t\u0011\u0005U7&!AA\u0002y\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002}\u0006AAo\\*ue&tw\rF\u0001_\u0003\u0019)\u0017/^1mgR!\u00111\u001eB\u0003\u0011%\t)NLA\u0001\u0002\u0004\ti-\u0001\u0003ECR\f\u0007cAAHaM)\u0001G!\u0004\u0003\u001aAa!q\u0002B\u000b\u0003O\t)'a\u001e\u0002\u000e6\u0011!\u0011\u0003\u0006\u0004\u0005'1\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005/\u0011\tBA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BAa\u0007\u0003\"5\u0011!Q\u0004\u0006\u0004\u0005?\u0011\u0017AA5p\u0013\u0011\t9F!\b\u0015\u0005\t%\u0011!B1qa2LH\u0003CAG\u0005S\u0011YC!\f\t\u000f\u0005m3\u00071\u0001\u0002(!9\u0011\u0011M\u001aA\u0002\u0005\u0015\u0004bBA:g\u0001\u0007\u0011qO\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Da\u0010\u0011\u000bU\u0013)D!\u000f\n\u0007\t]bK\u0001\u0004PaRLwN\u001c\t\n+\nm\u0012qEA3\u0003oJ1A!\u0010W\u0005\u0019!V\u000f\u001d7fg!I!\u0011\t\u001b\u0002\u0002\u0003\u0007\u0011QR\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B$!\ry&\u0011J\u0005\u0004\u0005\u0017\u0002'AB(cU\u0016\u001cGo\u0005\u00037)\n=\u0003\u0003\u0002B)\u00057j!Aa\u0015\u000b\t\tU#qK\u0001\u0006g24GG\u001b\u0006\u0003\u00053\n\u0001b\u001a:jujdW\rZ\u0005\u0005\u0005;\u0012\u0019FA\u0004M_\u001e<\u0017N\\4\u0002\u001dI,\u0007o\u001c:ugN+'O^5dKB!!1\rB5\u001b\t\u0011)GC\u0002\u0003h\u001d\u000bqa]3sm&\u001cW-\u0003\u0003\u0003l\t\u0015$A\u0004*fa>\u0014Ho]*feZL7-Z\u0001\u0015e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0011\t\tE$QO\u0007\u0003\u0005gR1Aa\u001aJ\u0013\u0011\u00119Ha\u001d\u0003)I+G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016\u0004BA!\u001d\u0003~%!!q\u0010B:\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\f1c]3sm\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u0004BA!\"\u0003\f6\u0011!q\u0011\u0006\u0004\u0005\u0013[\u0015\u0001\u00033fa2|\u00170\u001b;\n\t\t5%q\u0011\u0002\u0014'\u0016\u0014h/\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\u0015e\u0016dW-Y:f-&,woQ8om\u0016\u0014H/\u001a:\u0011\t\tM%QT\u0007\u0003\u0005+SAAa&\u0003\u001a\u0006Q1m\u001c8wKJ$XM]:\u000b\u0007\tm\u0015*A\u0003wS\u0016<8/\u0003\u0003\u0003 \nU%\u0001\u0006*fY\u0016\f7/\u001a,jK^\u001cuN\u001c<feR,'/A\tuCN\\\u0017iY2fgN\u001cVM\u001d<jG\u0016\u0004BA!\u001d\u0003&&!!q\u0015B:\u0005E!\u0016m]6BG\u000e,7o]*feZL7-Z\u0001\u0013e\u0016\u0004xN\u001d;GS2$XM]'baB,'\u000fE\u0002R\u0005[K1Aa,F\u0005I\u0011V\r]8si\u001aKG\u000e^3s\u001b\u0006\u0004\b/\u001a:\u0015!\tM&Q\u0017B\\\u0005s\u0013YL!0\u0003@\n\u0005\u0007CA)7\u0011\u001d\u0011yF\u0010a\u0001\u0005CBqA!\u001c?\u0001\u0004\u0011y\u0007C\u0004\u0003zy\u0002\rAa\u001f\t\u000f\t\u0005e\b1\u0001\u0003\u0004\"9!q\u0012 A\u0002\tE\u0005b\u0002BQ}\u0001\u0007!1\u0015\u0005\b\u0005Ss\u0004\u0019\u0001BVQ\rq$Q\u0019\t\u0005\u0005\u000f\u0014Y.\u0004\u0002\u0003J*!\u00111\u0017Bf\u0015\u0011\u0011iMa4\u0002\u000f\u0019\f7\r^8ss*!!\u0011\u001bBj\u0003\u0015\u0011W-\u00198t\u0015\u0011\u0011)Na6\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!A!7\u0002\u0007=\u0014x-\u0003\u0003\u0003^\n%'!C!vi><\u0018N]3e\u000399WM\\3sCR,'+\u001a9peR$bAa9\u0003j\nM\b\u0003\u0002B\u000e\u0005KLAAa:\u0003\u001e\t!a)\u001b7f\u0011\u001d\u0011Yo\u0010a\u0001\u0005[\f\u0001C]3q_J$H)\u001a4j]&$\u0018n\u001c8\u0011\u0007E\u0013y/C\u0002\u0003r\u0016\u0013q#T;mi&\u0014V\r\\3bg\u0016\fU\u000fZ5u%\u0016\u0004xN\u001d;\t\u000f\tUx\b1\u0001\u0003x\u0006\u0019\"/\u001a9peRTuN\u0019*v]\u000e{g\u000e^3yiB!!\u0011`B\u0001\u001b\t\u0011YP\u0003\u0003\u0002\u001c\tu(b\u0001B\u0000\u000f\u0006\u0019!n\u001c2\n\t\r\r!1 \u0002\u0014%\u0016\u0004xN\u001d;K_\n\u0014VO\\\"p]R,\u0007\u0010^\u0001\u001cO\u0016tWM]1uKNKgn\u001a7f%\u0016dW-Y:f%\u0016\u0004xN\u001d;\u0015\r\r%1qFB\"!\u0011\u0019Ya!\u000b\u000f\t\r511\u0005\b\u0005\u0007\u001f\u0019yB\u0004\u0003\u0004\u0012\rua\u0002BB\n\u00077qAa!\u0006\u0004\u001a9!\u0011QFB\f\u0013\u0005q\u0015B\u0001'N\u0013\tQ5*\u0003\u0002I\u0013&\u00191\u0011E$\u0002\u000b\u0015D8-\u001a7\n\t\r\u00152qE\u0001\u0018\u001bVdG/\u001b*fY\u0016\f7/Z!vI&$(+\u001a9peRT1a!\tH\u0013\u0011\u0019Yc!\f\u0003\u001dA+'OU3mK\u0006\u001cX\rR1uC*!1QEB\u0014\u0011\u001d\u0019\t\u0004\u0011a\u0001\u0007g\tqa^8sW\u0012K'\u000f\u0005\u0003\u00046\r}RBAB\u001c\u0015\u0011\u0019Ida\u000f\u0002\t\u0019LG.\u001a\u0006\u0004\u0007{\u0011\u0017a\u00018j_&!1\u0011IB\u001c\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\r\u0015\u0003\t1\u0001\u0004H\u0005I!/\u001a7fCN,\u0017\n\u001a\t\u0005\u0007\u0013\u001a\u0019&\u0004\u0002\u0004L)!1QJB(\u0003\u0015)H/\u001b7t\u0015\r\u0019\t&S\u0001\u0007I>l\u0017-\u001b8\n\t\rU31\n\u0002\u0014%\u0016dW-Y:f\u0013\u0012Le\u000eR1uC\n\f7/Z\u0001\rS:\u001cH/\u00198dK\u0012\u000bG/Y\u000b\u0003\u00077\u00022!UB/\u0013\r\u0019y&\u0012\u0002\r\u0013:\u001cH/\u00198dK\u0012\u000bG/Y\u0001\baJ,g/[3x)\u0011\tim!\u001a\t\u000f\t-(\t1\u0001\u0003n\u0006qam\u001c:nCR$UO]1uS>tG\u0003BA\u0014\u0007WBqa!\u001cD\u0001\u0004\u0019y'A\u0004sK2,\u0017m]3\u0011\t\rE41O\u0007\u0003\u0007\u001fJAa!\u001e\u0004P\t9!+\u001a7fCN,\u0007f\u0001\u001c\u0004zA!11PBA\u001b\t\u0019iH\u0003\u0003\u0004\u0000\tM\u0017AC:uKJ,w\u000e^=qK&!11QB?\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class MultiReleaseAuditReportComponent
implements Logging {
    private final ReportsService reportsService;
    private final ReleaseSearchService releaseSearchService;
    private final ServerConfiguration serverConfiguration;
    private final ReleaseViewConverter releaseViewConverter;
    private final TaskAccessService taskAccessService;
    private final ReportFilterMapper reportFilterMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String sanitizeFilename(String filename) {
        return MultiReleaseAuditReportComponent$.MODULE$.sanitizeFilename(filename);
    }

    public static ReleaseOrderMode DEFAULT_ORDER_MODE() {
        return MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_ORDER_MODE();
    }

    public static int DEFAULT_PAGE_SIZE() {
        return MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_PAGE_SIZE();
    }

    public static int FILENAME_MAX_LENGTH() {
        return MultiReleaseAuditReportComponent$.MODULE$.FILENAME_MAX_LENGTH();
    }

    public static SimpleDateFormat DATETIME_FORMATTER() {
        return MultiReleaseAuditReportComponent$.MODULE$.DATETIME_FORMATTER();
    }

    public static String SINGLE_REPORTS_DIR() {
        return MultiReleaseAuditReportComponent$.MODULE$.SINGLE_REPORTS_DIR();
    }

    public static String SINGLE_TITLE_SEPARATOR() {
        return MultiReleaseAuditReportComponent$.MODULE$.SINGLE_TITLE_SEPARATOR();
    }

    public static String MASTER_TITLE_SEPARATOR() {
        return MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE_SEPARATOR();
    }

    public static String MASTER_TITLE() {
        return MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE();
    }

    public static String ZIP_EXTENSION() {
        return MultiReleaseAuditReportComponent$.MODULE$.ZIP_EXTENSION();
    }

    public static String EXCEL_CONTENT_TYPE() {
        return MultiReleaseAuditReportComponent$.MODULE$.EXCEL_CONTENT_TYPE();
    }

    public static String EXCEL_EXTENSION() {
        return MultiReleaseAuditReportComponent$.MODULE$.EXCEL_EXTENSION();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        MultiReleaseAuditReportComponent multiReleaseAuditReportComponent = this;
        synchronized (multiReleaseAuditReportComponent) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public File generateReport(MultiReleaseAuditReport reportDefinition, ReportJobRunContext reportJobRunContext) {
        String reportName;
        Data data = new Data(reportDefinition.getGeneratedBy(), reportDefinition.getGeneratedOn(), (Seq<ReportFilter>)CollectionConverters$.MODULE$.ListHasAsScala(reportDefinition.filters()).asScala().toSeq());
        Seq releaseIds = this.releaseSearchService.searchAllIdsWithoutPermissionsCheck(data.reportFilters(), (Option)new Some((Object)ReleaseOrderMode.start_date), this.releaseSearchService.searchAllIdsWithoutPermissionsCheck$default$3(), this.releaseSearchService.searchAllIdsWithoutPermissionsCheck$default$4());
        this.logger().debug((Function0 & Serializable)() -> "Creating report for " + releaseIds.length() + " releases in job with id '" + reportJobRunContext.jobId() + "'.");
        int totalWorkItems = releaseIds.length() + 3;
        ReportJobProgressMonitor progressMonitor = reportJobRunContext.reportJobProgressMonitor();
        progressMonitor.sendTotalWorkItems(totalWorkItems);
        File workDir = reportJobRunContext.reportStorage().workdir();
        String reportDirName = reportName = reportJobRunContext.reportName();
        Path reportDir = Paths.get(workDir.getPath(), reportDirName);
        Path reportsDir = reportDir.resolve(MultiReleaseAuditReportComponent$.MODULE$.SINGLE_REPORTS_DIR());
        reportsDir.toFile().mkdirs();
        scala.collection.immutable.Map releasesData = (scala.collection.immutable.Map)releaseIds.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map done = (scala.collection.immutable.Map)tuple2._1();
            ReleaseIdInDatabase id = (ReleaseIdInDatabase)tuple2._2();
            scala.collection.immutable.Map toR = (scala.collection.immutable.Map)done.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id.adaptiveReleaseId()), MaybeData$.MODULE$.apply((Function0 & Serializable)() -> this.generateSingleReleaseReport(reportsDir, id))));
            progressMonitor.sendCompletedWorkItems(toR.keys().size());
            scala.collection.immutable.Map map = toR;
            return map;
        });
        this.logger().debug((Function0 & Serializable)() -> "Creating master report with all releases");
        MultiReleaseAuditReport.Data masterData = new MultiReleaseAuditReport.Data(data.generatedBy(), data.generatedOn(), this.instanceData(), this.reportFilterMapper.map(data.reportFilters()), (Seq<Try<Either<Tuple2<Throwable, MultiReleaseAuditReport.PerReleaseData>, MultiReleaseAuditReport.PerReleaseData>>>)releasesData.values().toSeq());
        Workbook masterWorkBook = MultiReleaseAuditReport$.MODULE$.getWorkBook(masterData);
        File masterFile = package$.MODULE$.writeToFile(reportDir, masterWorkBook, data.generatedOn(), MultiReleaseAuditReportComponent$.MODULE$.MASTER_TITLE());
        progressMonitor.sendCompletedWorkItems(releaseIds.length() + 1);
        File file = masterFile;
        File fullReport = ZipUtils$.MODULE$.archive((Seq)((IterableOnceOps)releasesData.values().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Try<Either<Tuple2<Throwable, MultiReleaseAuditReport.PerReleaseData>, MultiReleaseAuditReport.PerReleaseData>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    Either releaseData = (Either)success.value();
                    object = ((Tuple2)((MultiReleaseAuditReport.PerReleaseData)MaybeData$EitherOps$.MODULE$.getValue$extension(MaybeData$.MODULE$.EitherOps(releaseData))).storedPath().get())._1();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Try<Either<Tuple2<Throwable, MultiReleaseAuditReport.PerReleaseData>, MultiReleaseAuditReport.PerReleaseData>> x1) {
                Try<Either<Tuple2<Throwable, MultiReleaseAuditReport.PerReleaseData>, MultiReleaseAuditReport.PerReleaseData>> try_ = x1;
                boolean bl = try_ instanceof Success;
                return bl;
            }
        })).toSeq().$plus$colon((Object)file), reportDir.resolve(reportName + MultiReleaseAuditReportComponent$.MODULE$.ZIP_EXTENSION()).toFile(), (Option)new Some((Object)workDir.getPath()));
        progressMonitor.sendCompletedWorkItems(releaseIds.length() + 2);
        FileUtils.deleteDirectory((File)reportsDir.toFile());
        masterFile.delete();
        progressMonitor.sendCompletedWorkItems(totalWorkItems);
        return fullReport;
    }

    private MultiReleaseAuditReport.PerReleaseData generateSingleReleaseReport(Path workDir, ReleaseIdInDatabase releaseId) {
        MultiReleaseAuditReport.PerReleaseData perReleaseData;
        try {
            this.logger().debug((Function0 & Serializable)() -> "Working on report for [" + releaseId.adaptiveReleaseId().folderlessReleaseId() + "]");
            Release release = this.reportsService.findReleaseByReleaseIdInDatabase(releaseId);
            AuditReport.Data data = this.reportsService.fetchAuditReportData(release);
            Workbook workBook = AuditReport$.MODULE$.getWorkBook(data);
            Try<Either<Tuple2<Throwable, String>, String>> folder = this.reportsService.formattedReleaseFolderPath(release.getId());
            File stored = package$.MODULE$.writeToFile(workDir, workBook, data.releaseTree().release().getStartOrScheduledDate(), data.releaseTree().release().getTitle());
            PlannerReleaseItem root = data.releaseTree().root();
            perReleaseData = new MultiReleaseAuditReport.PerReleaseData(release.getTitle(), release.getOwner(), folder, (Date)Option$.MODULE$.apply((Object)release.getStartDate()).getOrElse((Function0 & Serializable)() -> release.getScheduledStartDate()), (Either<Date, Date>)((Either)root.endDate().map((Function1 & Serializable)dt -> scala.package$.MODULE$.Left().apply((Object)dt.toDate())).orElse((Function0 & Serializable)() -> root.dueDate().map((Function1 & Serializable)dt -> scala.package$.MODULE$.Right().apply((Object)dt.toDate()))).get()), this.formatDuration(release), release.getStatus(), data.releaseOverviewData().startedBy(), (Option<Tuple2<File, String>>)new Some((Object)new Tuple2((Object)stored, (Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(stored.getPath()), workDir.getParent().toFile().getPath())), File.separator))), data.releaseOverviewData().templateInfo());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to generate individual report for " + releaseId.adaptiveReleaseId().folderlessReleaseId() + ": " + e.getMessage(), e);
        }
        return perReleaseData;
    }

    private InstanceData instanceData() {
        Option<String> instanceName = this.reportsService.getInstanceName();
        Option instanceUrl = Option$.MODULE$.apply((Object)this.serverConfiguration.getServerUrl());
        Option<String> xlrVersion = this.reportsService.getInstanceVersion();
        return new InstanceData(instanceName, (Option<String>)instanceUrl, xlrVersion);
    }

    public Object preview(MultiReleaseAuditReport reportDefinition) {
        AuditReportRequest reportRequest = new AuditReportRequest(CollectionConverters$.MODULE$.ListHasAsScala(reportDefinition.filters()).asScala().toSeq(), Option$.MODULE$.apply((Object)MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_ORDER_MODE()));
        List<Release> releases = this.reportsService.getReleasesForPreview(reportRequest, 0L, MultiReleaseAuditReportComponent$.MODULE$.DEFAULT_PAGE_SIZE());
        ReleaseCountResults releaseCount = this.reportsService.getReleasesCountByStatus(reportRequest);
        List properties = Collections.emptyList();
        List<String> extensions = Collections.singletonList("progress");
        Buffer views = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(releases).asScala().map((Function1 & Serializable)r -> $this.releaseViewConverter.toFullView(r, $this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), properties, extensions, 2));
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releases"), (Object)CollectionConverters$.MODULE$.BufferHasAsJava(views).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseCount"), (Object)releaseCount)}))).asJava();
    }

    private String formatDuration(Release release) {
        Duration duration = (Duration)Option$.MODULE$.apply((Object)release.getActualDuration()).getOrElse((Function0 & Serializable)() -> release.getComputedPlannedDuration());
        return ExcelSheetWriter.PERIOD_FORMATTER.print((ReadablePeriod)duration.toPeriod().normalizedStandard(PeriodType.dayTime()));
    }

    @Autowired
    public MultiReleaseAuditReportComponent(ReportsService reportsService, ReleaseSearchService releaseSearchService, ReleaseService releaseService, ServerConfiguration serverConfiguration, ReleaseViewConverter releaseViewConverter, TaskAccessService taskAccessService, ReportFilterMapper reportFilterMapper) {
        this.reportsService = reportsService;
        this.releaseSearchService = releaseSearchService;
        this.serverConfiguration = serverConfiguration;
        this.releaseViewConverter = releaseViewConverter;
        this.taskAccessService = taskAccessService;
        this.reportFilterMapper = reportFilterMapper;
        Logging.$init$((Logging)this);
    }

    public static class Data
    implements Product,
    Serializable {
        private final String generatedBy;
        private final Date generatedOn;
        private final Seq<ReportFilter> reportFilters;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String generatedBy() {
            return this.generatedBy;
        }

        public Date generatedOn() {
            return this.generatedOn;
        }

        public Seq<ReportFilter> reportFilters() {
            return this.reportFilters;
        }

        public Data copy(String generatedBy, Date generatedOn, Seq<ReportFilter> reportFilters) {
            return new Data(generatedBy, generatedOn, reportFilters);
        }

        public String copy$default$1() {
            return this.generatedBy();
        }

        public Date copy$default$2() {
            return this.generatedOn();
        }

        public Seq<ReportFilter> copy$default$3() {
            return this.reportFilters();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.generatedBy();
                    break;
                }
                case 1: {
                    object = this.generatedOn();
                    break;
                }
                case 2: {
                    object = this.reportFilters();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "generatedBy";
                    break;
                }
                case 1: {
                    string = "generatedOn";
                    break;
                }
                case 2: {
                    string = "reportFilters";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            String string = this.generatedBy();
            String string2 = data.generatedBy();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Date date = this.generatedOn();
            Date date2 = data.generatedOn();
            if (date == null) {
                if (date2 != null) {
                    return false;
                }
            } else if (!((Object)date).equals(date2)) return false;
            Seq<ReportFilter> seq = this.reportFilters();
            Seq<ReportFilter> seq2 = data.reportFilters();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(String generatedBy, Date generatedOn, Seq<ReportFilter> reportFilters) {
            this.generatedBy = generatedBy;
            this.generatedOn = generatedOn;
            this.reportFilters = reportFilters;
            Product.$init$((Product)this);
        }
    }
}

