package com.xebialabs.xlrelease.reports

import com.xebialabs.xlplatform.utils.ResourceManagement
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReportComponent.{DATETIME_FORMATTER, EXCEL_EXTENSION, SINGLE_TITLE_SEPARATOR, sanitizeFilename}
import org.apache.poi.ss.usermodel.Workbook

import java.io.{File, FileOutputStream}
import java.nio.file.Path
import java.util.Date

package object audit {


  private[audit] def writeToFile(workDir: Path, workBook: Workbook, date: Date, title: String): File = {
    val sanitizedTitle = sanitizeFilename(title)
    val reportFileName = s"${DATETIME_FORMATTER.format(date)}$SINGLE_TITLE_SEPARATOR$sanitizedTitle"
    var stored: File = workDir.resolve(s"$reportFileName$EXCEL_EXTENSION").toFile
    var fileCounter = 1
    while (stored.exists) {
      stored = workDir.resolve(s"$reportFileName$SINGLE_TITLE_SEPARATOR$fileCounter$EXCEL_EXTENSION").toFile
      fileCounter += 1
    }
    ResourceManagement.using(new FileOutputStream(stored))(workBook.write)
    stored
  }

}
