package com.xebialabs.xlrelease.reports.job.impl.cleanup

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.quartz.release.scheduler.{QuartzScheduledService, ReleaseSchedulerService}
import org.quartz.JobBuilder.newJob
import org.quartz.SimpleScheduleBuilder.simpleSchedule
import org.quartz.TriggerBuilder.newTrigger
import org.quartz.{JobDetail, SimpleTrigger, Trigger}
import org.springframework.stereotype.Service

@Service
class ReportCleanerSchedulerService(val releaseSchedulerService: ReleaseSchedulerService,
                                    xlrConfig: XlrConfig) extends QuartzScheduledService {

  val jobName = "REPORT_CLEANER_JOB"
  val groupName = "REPORT_CLEANER"
  val cleanUpInterval: Long = xlrConfig.reporting.engine.cleanUpInterval

  lazy val job: JobDetail = newJob(classOf[ReportCleanerJob])
    .withDescription(s"Report Cleanup jobs")
    .withIdentity(jobName, groupName)
    .storeDurably(true)
    .build()

  lazy val trigger: SimpleTrigger = newTrigger()
    .withIdentity(jobName, groupName)
    .withDescription(s"Trigger ReportCleaner jobs")
    .withSchedule(simpleSchedule().withIntervalInMilliseconds(cleanUpInterval).repeatForever().withMisfireHandlingInstructionNowWithRemainingCount())
    .startNow()
    .build()

  override def getJobDetail: JobDetail = job

  override def getTrigger: Trigger = trigger

  override def name(): String = "Report Cleanup"

  override def isEnabled: Boolean = true
}
