package com.xebialabs.xlrelease.reports.repository

import com.xebialabs.xlrelease.domain.udm.reporting.{DeploymentRecord, DeploymentStatus}
import com.xebialabs.xlrelease.reports.repository.CommonRowAndParamsMapper._
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.DeploymentTaskReportingRecordTable
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.{RichStringAsTruncatable, params}
import com.xebialabs.xlrelease.repository.sql.persistence.{CiUid, Schema}

import java.sql.ResultSet

package object deployment {

  val DEPLOYMENT_TASK_REPORTING_RECORD_LIVE: Schema.DEPLOYMENT_TASK_REPORTING_RECORD.type = Schema.DEPLOYMENT_TASK_REPORTING_RECORD
  val DEPLOYMENT_TASK_REPORTING_RECORD_ARCHIVE: Schema.Archive.DEPLOYMENT_TASK_REPORTING_RECORD.type = Schema.Archive.DEPLOYMENT_TASK_REPORTING_RECORD

  private[deployment] def asQueryParameters(record: DeploymentRecord, taskUid: CiUid): Map[String, Any] = {
    mapCommonParams(record, taskUid) ++ params(
      "deploymentTask" -> record.getDeploymentTask.truncate(LONG_VARCHAR),
      "deploymentTaskUrl" -> record.getDeploymentTask_url.truncate(URL_VARCHAR),
      "environmentName" -> record.getEnvironmentName.truncate(LONG_VARCHAR),
      "applicationName" -> record.getApplicationName.truncate(LONG_VARCHAR),
      "version" -> record.getVersion.truncate(SHORT_VARCHAR),
      "status" -> record.getStatus.value().truncate(SHORT_VARCHAR)
    )
  }

  private[deployment] def deploymentItemRowMapper(rs: ResultSet,
                                                  deploymentRecord: DeploymentRecord,
                                                  targetId: String,
                                                  deploymentItemTable: DeploymentTaskReportingRecordTable
                                           ): DeploymentRecord = {
    mapCommonFields(rs, deploymentRecord, targetId, deploymentItemTable)
    deploymentRecord.setDeploymentTask(rs.getString(deploymentItemTable.DEPLOYMENT_TASK))
    deploymentRecord.setDeploymentTask_url(rs.getString(deploymentItemTable.DEPLOYMENT_TASK_URL))
    deploymentRecord.setEnvironmentName(rs.getString(deploymentItemTable.ENVIRONMENT_NAME))
    deploymentRecord.setApplicationName(rs.getString(deploymentItemTable.APPLICATION_NAME))
    deploymentRecord.setVersion(rs.getString(deploymentItemTable.VERSION))
    deploymentRecord.setStatus(DeploymentStatus.find(rs.getString(deploymentItemTable.STATUS)))
    deploymentRecord
  }

}
