/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.ReportApi;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;
import com.xebialabs.xlrelease.reports.job.domain.BaseStreamingReleaseReportDefinition;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.FacetService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.utils.TypeHelper;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;

@Controller
public class ReportApiImpl
implements ReportApi {
    private final ApplicationContext applicationContext;
    private final FacetService facetService;
    private final ReleaseService releaseService;
    private final PermissionChecker permissions;

    @Autowired
    public ReportApiImpl(ApplicationContext applicationContext, FacetService facetService, ReleaseService releaseService, PermissionChecker permissions) {
        this.applicationContext = applicationContext;
        this.facetService = facetService;
        this.releaseService = releaseService;
        this.permissions = permissions;
    }

    @Timed
    public List<TaskReportingRecord> getRecordsForRelease(String releaseId) {
        return this.searchRecords(new FacetFilters().withParentId(releaseId));
    }

    @Timed
    public List<TaskReportingRecord> getRecordsForTask(String taskId) {
        return this.searchRecords(new FacetFilters().withTargetId(taskId));
    }

    @Timed
    public List<TaskReportingRecord> searchRecords(FacetFilters facetFilters) {
        facetFilters.validate();
        String containerId = facetFilters.getParentId() != null ? facetFilters.getParentId() : facetFilters.getTargetId();
        this.permissions.checkView(Ids.releaseIdFrom((String)containerId));
        this.checkFiltersContainValidSearchableTypes(facetFilters);
        return this.facetService.search(facetFilters).stream().map(facet -> (TaskReportingRecord)facet).collect(Collectors.toList());
    }

    @Timed
    public Response downloadReleaseReport(String reportType, String releaseId) {
        BaseStreamingReleaseReportDefinition report = this.createReportDefinition(reportType, releaseId);
        StreamingOutput output = report.run();
        return ResponseHelper.streamFile((String)report.getFileName(), (StreamingOutput)output, (String)report.contentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timed
    public byte[] getReleaseReport(String reportType, String releaseId) throws IOException {
        BaseStreamingReleaseReportDefinition report = this.createReportDefinition(reportType, releaseId);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            report.run().write((OutputStream)outputStream);
        }
        return outputStream.toByteArray();
    }

    private BaseStreamingReleaseReportDefinition createReportDefinition(String reportType, String releaseId) {
        Release release = this.releaseService.findByIdIncludingArchived(releaseId);
        this.permissions.checkView(release);
        BaseStreamingReleaseReportDefinition report = (BaseStreamingReleaseReportDefinition)Type.valueOf((String)reportType).getDescriptor().newInstance(null);
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)report);
        report.setRelease(release);
        return report;
    }

    private void checkFiltersContainValidSearchableTypes(FacetFilters facetFilters) {
        Type taskReportingRecordType = Type.valueOf(TaskReportingRecord.class);
        if (facetFilters.getTypes() == null || facetFilters.getTypes().isEmpty()) {
            facetFilters.setTypes(CollectionConverters.asJava((Seq)TypeHelper.getAllSubtypesOf((Type)taskReportingRecordType)));
        } else {
            Predicate<Type> isUnsupportedType = facetType -> !facetType.instanceOf(taskReportingRecordType);
            facetFilters.getTypes().removeIf(isUnsupportedType);
            if (facetFilters.getTypes().isEmpty()) {
                throw new IllegalArgumentException("Filter contains unsupported types");
            }
        }
    }
}

