package com.xebialabs.xlrelease.reports.config

import com.xebialabs.xlrelease.config.CacheManagementConstants.REPORTS_CACHE_MANAGER
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.reports.config.ReportServiceCacheConfig.REPORTS_CACHES_SETTINGS
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class ReportServiceCacheConfig(xlrConfig: XlrConfig) {

  @Bean(value = Array(REPORTS_CACHE_MANAGER))
  def reportsCacheManager() = new XlrCaffeineCacheManager(REPORTS_CACHE_MANAGER, xlrConfig.getCacheSettings(REPORTS_CACHES_SETTINGS))
}

object ReportServiceCacheConfig {

  private val CACHE_NAME = "reports"
  val REPORTS_CACHES_SETTINGS = "reporting"
  val RELEASE_DURATION_CACHE: String = CACHE_NAME + "-release-duration"
  val COMPLETED_RELEASES_CACHE: String = CACHE_NAME + "-completed-releases"
  val AVERAGE_AND_LONGEST_RELEASE_DURATION_CACHE: String = CACHE_NAME + "-average-and-longest-release-duration"
  val PEOPLE_MOST_INVOLVED_CACHE: String = CACHE_NAME + "-people-most-involved"
  val LONGEST_TASKS_CACHE: String = CACHE_NAME + "-longest-tasks"
  val LONGEST_TASK_TYPES_CACHE: String = CACHE_NAME + "-longest-task-types"
  val AVERAGE_AND_LONGEST_TASK_DURATION_CACHE: String = CACHE_NAME + "-average-and-longest-task-duration"
  val RELEASE_AUTOMATION_CACHE: String = CACHE_NAME + "-release-automation"
  val MOST_RECENT_RELEASES_CACHE: String = CACHE_NAME + "-most-recent-releases"
  val LONGEST_PHASES_CACHE: String = CACHE_NAME + "-longest-phases"
  val NUMBER_OF_RELEASES_CACHE: String = CACHE_NAME + "-number-of-releases"
}
