package com.xebialabs.xlrelease.reports.domain

import com.xebialabs.xlrelease.reports.excel.ExcelSheetWriter
import org.apache.poi.xssf.usermodel.XSSFSheet

case class ReportCellError(sheet: XSSFSheet, row: Int, col: Int, throwable: Throwable)
object ReportCellError {
  def apply(sheetWriter: ExcelSheetWriter, throwable: Throwable) : ReportCellError = {
    new ReportCellError(sheetWriter.getSheet, sheetWriter.getRowIndex, sheetWriter.getColumnIndex, throwable)
  }
}