package com.xebialabs.xlrelease.reports.job.impl.cleanup

import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.actors.initializer.ActorInitializer
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.reports.job.impl.ReportExecutorService
import org.apache.pekko.actor.{ActorRef, PoisonPill}
import org.apache.pekko.cluster.singleton.{ClusterSingletonManager, ClusterSingletonManagerSettings, ClusterSingletonProxy, ClusterSingletonProxySettings}

import scala.concurrent.{Await, Promise}

trait ReportCleanerActorInitializer extends ActorInitializer {
  private val actorPromise = Promise[ActorRef]()

  def actorRef(): ActorRef = {
    Await.result(actorPromise.future, xlrConfig.timeouts.systemInitialization)
  }

  override def initialize(): Unit = {
    resolveActor(createActor())
  }

  protected def createActor(): ActorRef

  private def resolveActor(actor: ActorRef): Unit = {
    actorPromise.success(actor)
  }

  def xlrConfig: XlrConfig
}

object ReportCleanerActorInitializer {

  class ClusteredReportCleanerActorInitializer(systemHolder: ActorSystemHolder,
                                               val xlrConfig: XlrConfig,
                                               reportCleanerOperations: ReportCleanerOperations,
                                               reportExecutor: ReportExecutorService
                                              ) extends ReportCleanerActorInitializer {

    private val system = systemHolder.actorSystem

    system.actorOf(ClusterSingletonManager.props(
      singletonProps = ReportCleanerActor.props(reportCleanerOperations, reportExecutor),
      terminationMessage = PoisonPill,
      settings = ClusterSingletonManagerSettings(system)),
      name = ReportCleanerActor.name
    )

    val reportCleanerActor: ActorRef = system.actorOf(
      props = ClusterSingletonProxy.props(
        singletonManagerPath = s"user/${ReportCleanerActor.name}",
        settings = ClusterSingletonProxySettings(system)
      ),
      name = s"${ReportCleanerActor.name}Proxy")

    system.actorOf(NodeRemovalListenerActor.props(reportCleanerActor))

    override protected def createActor(): ActorRef = reportCleanerActor
  }

}
