package com.xebialabs.xlrelease.reports.repository.itsm

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.domain.udm.reporting.ItsmRecord
import com.xebialabs.xlrelease.reports.repository.ArchivedTasksRepository
import com.xebialabs.xlrelease.repository.FacetRepository.SpecializedFacetRepository
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence
import com.xebialabs.xlrelease.repository.{FacetRepository, FacetRepositoryDispatcher}
import com.xebialabs.xlrelease.service.CiIdService
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class ItsmRecordRepository @Autowired()(val ciIdService: CiIdService,
                                        val facetRepositoryDispatcher: FacetRepositoryDispatcher,
                                        taskPersistence: TaskPersistence,
                                        archivedTasksRepository: ArchivedTasksRepository,
                                        @Qualifier("xlrRepositoryJdbcTemplate") val liveJdbcTemplate: JdbcTemplate,
                                        @Qualifier("xlrRepositorySqlDialect") val liveDialect: Dialect,
                                        @Qualifier("reportingJdbcTemplate") val archiveJdbcTemplate: JdbcTemplate,
                                        @Qualifier("reportingSqlDialect") val archiveDialect: Dialect
                                      )
  extends SpecializedFacetRepository(Type.valueOf(classOf[ItsmRecord]))
    with FacetRepository.DatabaseDispatcher[SpecializedFacetRepository] {

  override def isArchived(releaseId: String): Boolean = facetRepositoryDispatcher.isArchived(releaseId)

  lazy val liveRepository: ItsmRecordLiveRepository =
    new ItsmRecordLiveRepository(taskPersistence, ciIdService, liveJdbcTemplate, liveDialect)
  lazy val archiveRepository: ItsmRecordArchiveRepository =
    new ItsmRecordArchiveRepository(archivedTasksRepository, ciIdService, archiveJdbcTemplate, archiveDialect)

  facetRepositoryDispatcher.register(this)
}
