package com.xebialabs.xlrelease.reports.audit

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.reports.filters.ReportFilter
import com.xebialabs.xlrelease.reports.job.api.ReportJobRunContext
import com.xebialabs.xlrelease.reports.job.domain.BaseReportDefinition
import com.xebialabs.xlrelease.utils.XLTypes._
import org.springframework.beans.factory.annotation.Autowired

import java.io.File
import java.util.{List => JList}
import scala.beans.BeanProperty

@Metadata (description = "Multi release audit report", versioned = false)
class MultiReleaseAuditReport extends BaseReportDefinition {

  @BeanProperty
  @Autowired
  @transient
  var reportComponent: MultiReleaseAuditReportComponent = _

  override def reportName: String = "Digital_ai Release Audit Report"

  @BeanProperty
  @XLProperty(asContainment = true)
  var filters: JList[ReportFilter] = _

  @BeanProperty
  @XLProperty(hidden = true)
  val contentType: String = "application/zip"

  override def run(runContext: ReportJobRunContext): File = {
    reportComponent.generateReport(this, runContext)
  }

  override def preview(): Any = {
    reportComponent.preview(this)
  }
}
