package com.xebialabs.xlrelease.reports.job.impl.cleanup

import com.xebialabs.xlplatform.cluster.ClusterMode.FULL
import com.xebialabs.xlrelease.actors.{ActorSystemHolder, ManagedActor}
import com.xebialabs.xlrelease.reports.job.impl.cleanup.ReportCleanerActorInitializer.{NodeRemovalListenerActorHolder, ReportCleanerActorHolder}
import org.springframework.context.annotation.{Bean, Configuration, Profile}

object ReportCleanerActorInitializer {
  type ReportCleanerActorHolder = ManagedActor[ReportCleanerActor]
  type NodeRemovalListenerActorHolder = ManagedActor[NodeRemovalListenerActor]
}

@Configuration
@Profile(Array(FULL))
class ReportCleanerActorInitializer(actorSystemHolder: ActorSystemHolder) {

  @Bean
  def reportCleanerActorHolder: ReportCleanerActorHolder = {
    actorSystemHolder.clusterSingletonActorProxyOf(classOf[ReportCleanerActor], ReportCleanerActor.name)
  }

  @Bean
  def nodeRemovalListenerActorHolder: NodeRemovalListenerActorHolder = {
    actorSystemHolder.actorOf(classOf[NodeRemovalListenerActor], "nodeRemovalListenerActor")
  }
}
