package com.xebialabs.xlrelease.reports.repository.plan

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.domain.udm.reporting.PlanRecord
import com.xebialabs.xlrelease.reports.repository.ArchivedTasksRepository
import com.xebialabs.xlrelease.repository.FacetRepository.SpecializedFacetRepository
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence
import com.xebialabs.xlrelease.repository.{FacetRepository, FacetRepositoryDispatcher}
import com.xebialabs.xlrelease.service.CiIdService
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class PlanRecordRepository @Autowired()(val ciIdService: CiIdService,
                                        val facetRepositoryDispatcher: FacetRepositoryDispatcher,
                                        taskPersistence: TaskPersistence,
                                        archivedTasksRepository: ArchivedTasksRepository,
                                        @Qualifier("xlrRepositoryJdbcTemplate") val liveJdbcTemplate: JdbcTemplate,
                                        @Qualifier("xlrRepositorySqlDialect") val liveDialect: Dialect,
                                        @Qualifier("reportingJdbcTemplate") val archiveJdbcTemplate: JdbcTemplate,
                                        @Qualifier("reportingSqlDialect") val archiveDialect: Dialect) extends
  SpecializedFacetRepository(Type.valueOf(classOf[PlanRecord]))
  with FacetRepository.DatabaseDispatcher[SpecializedFacetRepository] {
  override def liveRepository: PlanRecordLiveRepository =
    new PlanRecordLiveRepository(taskPersistence, ciIdService, liveJdbcTemplate, liveDialect)

  override def archiveRepository: PlanRecordArchiveRepository =
    new PlanRecordArchiveRepository(archivedTasksRepository, ciIdService, archiveJdbcTemplate, archiveDialect)

  override def isArchived(releaseId: String): Boolean = facetRepositoryDispatcher.isArchived(releaseId)

  facetRepositoryDispatcher.register(this)
}
