package com.xebialabs.xlrelease.reports.domain

import com.xebialabs.xlrelease.domain.ReleaseActivity._
import com.xebialabs.xlrelease.domain.{ActivityLogEntry, Release, ReleaseActivity}

case class ReleaseData(release: Release,
                       allLogEntries: Seq[ActivityLogEntry],
                       completedByActivityLogEntriesByTask: Map[String, ActivityLogEntry],
                       startedByLogEntry: Option[ActivityLogEntry],
                       createdByLogEntry: Option[ActivityLogEntry])

object ReleaseData {

  private def getActivityLogByType(activityLogEntries: Seq[ActivityLogEntry], types: Set[ReleaseActivity]): Option[ActivityLogEntry] = {
    val typesAsStrings = types.map(_.name())
    activityLogEntries.find(e => typesAsStrings.contains(e.getActivityType))
  }

  def apply(release: Release, activityLogEntries: Seq[ActivityLogEntry]): ReleaseData =
    ReleaseData(
      release = release,
      allLogEntries = activityLogEntries,
      completedByActivityLogEntriesByTask = activityLogEntries
        .filter(_.getActivityType == ReleaseActivity.TASK_COMPLETED.name)
        .groupBy(_.getTargetId)
        .view
        .mapValues(_.head)
        .toMap,
      startedByLogEntry = getActivityLogByType(activityLogEntries,
        Set(RELEASE_STARTED, RELEASE_STARTED_FROM_CREATE_RELEASE_TASK, WORKFLOW_EXECUTION_STARTED)),
      createdByLogEntry = getActivityLogByType(activityLogEntries,
        Set(
          RELEASE_CREATED_FROM_TEMPLATE,
          WORKFLOW_EXECUTION_CREATED_FROM_TEMPLATE,
          RELEASE_CREATED_FROM_CREATE_RELEASE_TASK,
          RELEASE_CREATED_FROM_DSL,
          WORKFLOW_EXECUTION_CREATED_FROM_DSL,
          WORKFLOW_TEMPLATE_CREATED_FROM_DSL,
          RELEASE_RESTORED_FROM_REVISION,
          RELEASE_CREATED,
          TEMPLATE_CREATED
      ))
    )

}
