package com.xebialabs.xlrelease.reports.domain

import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReportComponent
import com.xebialabs.xlrelease.reports.excel.ReleaseReport
import com.xebialabs.xlrelease.reports.job.domain.BaseStreamingReleaseReportDefinition
import com.xebialabs.xlrelease.reports.service.ReportsService
import com.xebialabs.xlrelease.service.ReleaseService
import org.springframework.beans.factory.annotation.Autowired

import jakarta.ws.rs.core.StreamingOutput
import scala.beans.BeanProperty

class ReleaseExcelReport extends BaseStreamingReleaseReportDefinition {

  @BeanProperty
  @Autowired
  var reportsService: ReportsService = _

  @BeanProperty
  @Autowired
  var releaseService: ReleaseService = _

  override def reportName: String = "Release Report"

  override def contentType: String = MultiReleaseAuditReportComponent.EXCEL_CONTENT_TYPE

  override def run(): StreamingOutput = {
    releaseService.decorateRemovingUnnecessaryFields(release)
    val data = reportsService.fetchReleaseReportData(release)
    val workbook = new ReleaseReport(data).getWorkBook()
    fileName = MultiReleaseAuditReportComponent.sanitizeFilename(release.getTitle) + MultiReleaseAuditReportComponent.EXCEL_EXTENSION
    val output: StreamingOutput = workbook.write
    output
  }
}
