package com.xebialabs.xlrelease.reports.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

public class PhaseDuration {
    private String title;
    private String release;
    private long duration;

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String releaseId;

    public PhaseDuration(String title, String release, long duration, String releaseId) {
        this.title = title;
        this.release = release;
        this.duration = duration;
        this.releaseId = releaseId;
    }

    public String getTitle() {
        return title;
    }

    public String getRelease() {
        return release;
    }

    public long getDuration() {
        return duration;
    }

    public String getReleaseId() {
        return releaseId;
    }
}
