package com.xebialabs.xlrelease.reports.job.impl.cleanup

import com.xebialabs.xlrelease.reports.job.impl.cleanup.ReportCleanerActor.{MissingNodesClusterCleanup, NodeCleanup}
import com.xebialabs.xlrelease.reports.job.impl.cleanup.ReportCleanerActorInitializer.ReportCleanerActorHolder
import com.xebialabs.xlrelease.support.pekko.spring.SpringActor
import org.apache.pekko.actor.{Actor, ActorLogging}
import org.apache.pekko.cluster.Cluster
import org.apache.pekko.cluster.ClusterEvent.{InitialStateAsSnapshot, MemberRemoved}

@SpringActor
class NodeRemovalListenerActor(reportCleanerActor: ReportCleanerActorHolder) extends Actor with ActorLogging {

  import context._

  private val cluster: Cluster = Cluster(system)

  @scala.throws[Exception](classOf[Exception])
  override def preStart(): Unit = {
    super.preStart()
    cluster.subscribe(self, InitialStateAsSnapshot, classOf[MemberRemoved])
    reportCleanerActor ! MissingNodesClusterCleanup
  }

  @scala.throws[Exception](classOf[Exception])
  override def postStop(): Unit = {
    cluster.unsubscribe(self)
    super.postStop()
  }

  override def receive: Receive = {
    case MemberRemoved(member, _) =>
      // ManagedActor is reset when node is going down.
      // System should not sent any messages to it when it is in the process of shutting down.
      if (reportCleanerActor.isInitialized) {
        reportCleanerActor ! NodeCleanup(member)
      }
    case msg => log.warning(s"Received unexpected message: $msg")
  }
}
