package com.xebialabs.xlrelease.reports.utils;

import java.util.List;
import jakarta.ws.rs.QueryParam;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.booter.local.utils.Strings.isBlank;

public class ReportUtils {
    public static List<String> splitTags(@QueryParam("tags") String tagsInput) {
        if (isBlank(tagsInput)) {
            return newArrayList();
        }
        List<String> tags = newArrayList(tagsInput.split(","));
        checkArgument(tags.size() <= 100, "At most 100 tags are supported");
        return tags;
    }
}
