package com.xebialabs.xlrelease.reports.dto;

import org.joda.time.DateTime;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

public class ReleaseDuration {
    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String releaseId;
    private String title;
    private DateTime endDate;
    private long duration;

    public ReleaseDuration(String releaseId, String title, DateTime endDate, long duration) {
        this.title = title;
        this.endDate = endDate;
        this.duration = duration;
        this.releaseId = releaseId;
    }

    public String getReleaseId() {
        return releaseId;
    }

    public String getTitle() {
        return title;
    }

    public DateTime getEndDate() {
        return endDate;
    }

    public long getDuration() {
        return duration;
    }
}
