package com.xebialabs.xlrelease.reports.api.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.xebialabs.xlrelease.api.v1.forms.TimeFrame;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;

import static com.xebialabs.xlrelease.api.v1.forms.TimeFrame.LAST_SEVEN_DAYS;

public class ReportForm {
    private Date from;
    private Date to;
    private TimeFrame timeFrame = LAST_SEVEN_DAYS;
    private String tags;
    private boolean userSpecific = true;
    private List<ReportFilter> filters = new ArrayList<>();
    private boolean refresh;

    public Date getFrom() {
        return from;
    }

    public void setFrom(final Date from) {
        this.from = from;
    }

    public Date getTo() {
        return to;
    }

    public void setTo(final Date to) {
        this.to = to;
    }

    public TimeFrame getTimeFrame() {
        return timeFrame;
    }

    public void setTimeFrame(final TimeFrame timeFrame) {
        this.timeFrame = timeFrame;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(final String tags) {
        this.tags = tags;
    }

    public boolean isUserSpecific() {
        return userSpecific;
    }

    public void setUserSpecific(final boolean userSpecific) {
        this.userSpecific = userSpecific;
    }

    public List<ReportFilter> getFilters() {
        return filters;
    }

    public void setFilters(final List<ReportFilter> filters) {
        this.filters = filters;
    }

    public boolean isRefresh() {
        return refresh;
    }

    public void setRefresh(final boolean refresh) {
        this.refresh = refresh;
    }
}
