package com.xebialabs.xlrelease.reports.excel;

import java.util.List;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

import com.xebialabs.xlrelease.reports.dto.ReleaseDuration;

public class TopLongestReleaseExport extends Export {
    private List<ReleaseDuration> topLongestReleases;

    public static final int TITLE_COLUMN = 0;
    public static final int DURATION_COLUMN = 1;

    private static final String TITLE_HEADER = "Release";
    private static final String DURATION_HEADER = "Duration";

    public TopLongestReleaseExport(List<ReleaseDuration> topLongestReleases) {
        super();
        this.topLongestReleases = topLongestReleases;
    }

    @Override
    public void addContent() {
        for (ReleaseDuration releaseDuration : topLongestReleases) {
            XSSFRow row = sheet.createRow(rowIndex++);

            CellUtil.createCell(row, TITLE_COLUMN, releaseDuration.getTitle());
            XSSFCell duration = row.createCell(DURATION_COLUMN);
            duration.setCellValue(releaseDuration.getDuration());
        }
    }

    @Override
    protected void setColumnsWidth() {
        sheet.setColumnWidth(TITLE_COLUMN, numberOfCharacter(30));
        sheet.setColumnWidth(DURATION_COLUMN, numberOfCharacter(15));
    }

    @Override
    protected void addHeaderRow() {
        XSSFRow row = sheet.createRow(rowIndex++);
        CellUtil.createCell(row, TITLE_COLUMN, TITLE_HEADER);
        CellUtil.createCell(row, DURATION_COLUMN, DURATION_HEADER);
        sheet.createRow(rowIndex++);
    }
}
