package com.xebialabs.xlrelease.reports

import com.xebialabs.deployit.plugin.api.reflect.{PropertyDescriptor, PropertyKind, Type}
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord

import java.time.Instant.EPOCH
import java.time.temporal.ChronoUnit
import java.util.Date

package object upgrade {

  val deprecatedFacetTypeToRecordType = Map(
    Type.valueOf("udm.PlanFacet") -> Type.valueOf("udm.PlanRecord"),
    Type.valueOf("udm.BuildFacet") -> Type.valueOf("udm.BuildRecord"),
    Type.valueOf("udm.ItsmFacet") -> Type.valueOf("udm.ItsmRecord"),
    Type.valueOf("udm.DeploymentFacet") -> Type.valueOf("udm.DeploymentRecord"),
    Type.valueOf("udm.CodeComplianceFacet") -> Type.valueOf("udm.CodeComplianceRecord"),
  )

  // these are old names for facets, that existed in 9.0.x
  val deprecatedFacetTypes = deprecatedFacetTypeToRecordType.keySet

  def setDefaultValuesForRequiredProperties(record: TaskReportingRecord): Unit = {
    record.getType.getDescriptor.getPropertyDescriptors.forEach { pd: PropertyDescriptor =>
      pd.getKind match {
        case PropertyKind.STRING if pd.isRequired && (pd.get(record) == null || "".equals(pd.get(record))) => record.setProperty(pd.getName, "<unknown>")
        case PropertyKind.DATE if pd.isRequired && (pd.get(record) == null) => record.setProperty(pd.getName, Date.from(EPOCH.plus(1, ChronoUnit.SECONDS))) // Mysql does not allow 1970-01-01 00:00:00 but allows 1970-01-01 00:00:01
        case PropertyKind.INTEGER if pd.isRequired && (pd.get(record) == null) => record.setProperty(pd.getName, 0)
        case _ =>
      }
    }
  }

  def renewDeprecatedTypes(record: TaskReportingRecord): Unit = for (newType <- deprecatedFacetTypeToRecordType.get(record.getType)) record.setType(newType)

}
