package com.xebialabs.xlrelease.reports.excel;

import java.util.List;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

import com.xebialabs.xlrelease.reports.dto.UserParticipation;

public class TopPeopleMostInvolvedExport extends Export {
    private List<UserParticipation> topPeopleMostInvolved;

    public static final int PERSON_COLUMN = 0;
    public static final int DURATION_COLUMN = 1;
    public static final int TASK_HANDLED_COLUMN = 2;

    private static final String PERSON_HEADER = "Person";
    private static final String DURATION_HEADER = "Time spent";
    private static final String TASK_HANDLED_HEADER = "Task handled";

    public TopPeopleMostInvolvedExport(List<UserParticipation> topPeopleMostInvolved) {
        super();
        this.topPeopleMostInvolved = topPeopleMostInvolved;
    }

    @Override
    protected void addContent() {
        for (UserParticipation userParticipation : topPeopleMostInvolved) {
            XSSFRow row = sheet.createRow(rowIndex++);

            String user = userParticipation.getUser().getFullName();
            if (user == null) {
                user = userParticipation.getUser().getUsername();
            }
            CellUtil.createCell(row, PERSON_COLUMN, user);
            XSSFCell duration = row.createCell(DURATION_COLUMN);
            duration.setCellValue(userParticipation.getTimeSpent());
            XSSFCell taskHandled = row.createCell(TASK_HANDLED_COLUMN);
            taskHandled.setCellValue(userParticipation.getTasksHandled());
        }
    }

    @Override
    protected void setColumnsWidth() {
        sheet.setColumnWidth(PERSON_COLUMN, numberOfCharacter(15));
        sheet.setColumnWidth(DURATION_COLUMN, numberOfCharacter(15));
        sheet.setColumnWidth(TASK_HANDLED_COLUMN, numberOfCharacter(15));
    }

    @Override
    protected void addHeaderRow() {
        XSSFRow row = sheet.createRow(rowIndex++);
        CellUtil.createCell(row, PERSON_COLUMN, PERSON_HEADER);
        CellUtil.createCell(row, DURATION_COLUMN, DURATION_HEADER);
        CellUtil.createCell(row, TASK_HANDLED_COLUMN, TASK_HANDLED_HEADER);
        sheet.createRow(rowIndex++);
    }
}
