package com.xebialabs.xlrelease.reports.job.impl.s3

import com.xebialabs.xlrelease.reports.job.api.{AbstractStreamingReportResult, ReportResult}

import java.io.InputStream
import java.net.URI

private[s3] class S3StreamingReportResult(private val storage: S3ReportStorage, contextUri: URI, reportResult: ReportResult)
  extends AbstractStreamingReportResult(reportResult) {

  override protected lazy val resolvedUri: URI = {
    val unresolvedUri = new URI(reportResult.resultUri)
    if (unresolvedUri.isAbsolute) {
      unresolvedUri
    } else {
      contextUri.resolve(unresolvedUri)
    }
  }

  override protected def inputStream(): InputStream = storage.s3Storage.get(resolvedUri)
}
