package com.xebialabs.xlrelease.reports.mbeans;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.reports.service.ReportServiceCache;

@Component
@ManagedResource(objectName = "com.xebialabs.xlrelease.settings:name=ReportsCacheControl", description="Cache control")
public class ReportsCacheControl {
    private ReportServiceCache reportServiceCache;

    @Autowired
    public ReportsCacheControl(ReportServiceCache reportServiceCache) {
        this.reportServiceCache = reportServiceCache;
    }

    @ManagedOperation(description="Clear reports cache")
    public void clearReportsCache() {
        this.reportServiceCache.clearCache();
    }
}

