package com.xebialabs.xlrelease.scm.connector.events.handler

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.events.{ConfigurationDeletedEvent, ConfigurationUpdatedEvent}
import com.xebialabs.xlrelease.domain.scm.connector.JGitConnectorConfig
import com.xebialabs.xlrelease.events.{AsyncSubscribe, EventListener, XLReleaseEventListener}
import com.xebialabs.xlrelease.scm.connector.actors.JGitRepoCleanerActor.Clean
import com.xebialabs.xlrelease.scm.connector.actors.JGitRepoCleanerActorHolder
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
@EventListener
class JGitConnectorConfigEventListener @Autowired()(jGitRepoCleanerActorHolder: JGitRepoCleanerActorHolder) extends XLReleaseEventListener with Logging {
  private lazy val jGitRepoCleanerActor = jGitRepoCleanerActorHolder.actorRef()
  private lazy val jgitType = Type.valueOf(classOf[JGitConnectorConfig])

  @AsyncSubscribe
  def onConfigurationDelete(event: ConfigurationDeletedEvent): Unit = {
    if (event.conf.getType.instanceOf(jgitType)) {
      val config = event.conf.asInstanceOf[JGitConnectorConfig]
      jGitRepoCleanerActor ! Clean(config)
    }
  }

  @AsyncSubscribe
  def onConfigurationUpdate(event: ConfigurationUpdatedEvent): Unit = {
    if (event.updated.getType.instanceOf(jgitType)) {
      val config = event.updated.asInstanceOf[JGitConnectorConfig]
      jGitRepoCleanerActor ! Clean(config)
    }
  }
}
