package com.xebialabs.xlrelease.domain.scm.connector

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.domain.PropertyConfiguration
import com.xebialabs.xlrelease.scm.connector.ScmConnector

import scala.beans.BeanProperty

trait ScmConnectorConfig {
  def getConnector: ScmConnector
}

abstract class ScmCredential extends BaseConfigurationItem

@Metadata(label = "Source Control Management", description = "", virtual = true)
abstract class BaseScmConnectorConfig extends PropertyConfiguration with ScmConnectorConfig

abstract class RestApiScmConnectorConfig[C <: ScmCredential] extends BaseScmConnectorConfig {

  @BeanProperty
  @Property(label = "REST API URL")
  val restApiUrl: String = ""

  @BeanProperty
  @Property(
    label = "Repository full name",
    description = "Full name of the repository on which changes will be stored (e.g. your_organization/your_repository)")
  var repository: String = ""

  @BeanProperty
  @Property(label = "Branch", description = "Branch on which changes will be stored")
  var branch: String = "master"

  var credential: C

  override def setId(id: String): Unit = {
    super.setId(id)
    if (null != credential) {
      credential.setId(id + "/credential")
    }
  }
}

