/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scm.connector;

import java.util.Optional;

public class GitConnectionSettings {
    private final String url;
    private final String branch;
    private final String authenticationMethod;
    private final String username;
    private final String password;
    private final String domain;
    private final String proxyHost;
    private final Integer proxyPort;
    private final String proxyUsername;
    private final String proxyPassword;
    private final String proxyDomain;
    private final String committerUsername;
    private final String committerEmail;

    public GitConnectionSettings(String url, String branch, String authenticationMethod, String username, String password, String domain, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String proxyDomain, String committerUsername, String committerEmail) {
        this.url = url;
        this.branch = branch;
        this.authenticationMethod = authenticationMethod;
        this.username = username;
        this.password = password;
        this.domain = domain;
        this.proxyHost = proxyHost;
        this.proxyPort = Optional.ofNullable(proxyPort).filter(x -> !x.isEmpty()).map(Integer::parseInt).orElse(-1);
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.proxyDomain = proxyDomain;
        this.committerUsername = committerUsername;
        this.committerEmail = committerEmail;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public boolean shouldUseAuthentication() {
        return this.getPassword() != null && !this.getPassword().isEmpty() && this.getAuthenticationMethod() != null;
    }

    public boolean shouldUseProxy() {
        return this.getProxyHost() != null && !this.getProxyHost().isEmpty();
    }

    public boolean shouldUseProxyAuthentication() {
        return this.getProxyUsername() != null && !this.getProxyUsername().isEmpty() && this.getProxyPassword() != null && !this.getProxyPassword().isEmpty();
    }

    public String getCommitterUsername() {
        return this.committerUsername;
    }

    public String getCommitterEmail() {
        return this.committerEmail;
    }

    public boolean shouldUseNtlmProxyAuthentication() {
        return this.getProxyDomain() != null && !this.getProxyDomain().isEmpty();
    }
}

