package com.xebialabs.xlrelease.domain.scm.connector

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.scm.connector.BitBucketCloudScmConnector

import scala.beans.BeanProperty

@Metadata(label = "BitBucket Cloud", description = "BitBucket Cloud connector configuration")
class BitBucketCloudScmConnectorConfig extends RestApiScmConnectorConfig[BitBucketCloudScmCredential] {
  @BeanProperty
  @Property(label = "Credentials", description = "Select the type of credentials to access the BitBucket Cloud repository")
  var credential: BitBucketCloudScmCredential = _

  override def getConnector = new BitBucketCloudScmConnector(this)
}

abstract class BitBucketCloudScmCredential extends ScmCredential {
  @BeanProperty
  @Property(asContainment = true)
  var config: BitBucketCloudScmConnectorConfig = _
}

@Metadata(label = "Username and password")
class BitBucketCloudUsernamePasswordCredential extends BitBucketCloudScmCredential {
  @BeanProperty
  @Property(description = "The BitBucket Cloud login username")
  var username: String = _

  @BeanProperty
  @Property(description = "The BitBucket Cloud login password", password = true)
  var password: String = _
}

@Metadata(label = "App password")
class BitBucketCloudAppPassword extends BitBucketCloudScmCredential {
  @BeanProperty
  @Property(description = "The BitBucket Cloud login username")
  var username: String = _

  @BeanProperty
  @Property(description = "The App password for BitBucket Cloud", label = "App password", password = true)
  var appPassword: String = _
}

@Metadata(label = "API key")
class BitBucketCloudAPIKey extends BitBucketCloudScmCredential {

  @BeanProperty
  @Property(description = "The BitBucket Cloud team name", label = "Team name")
  var teamName: String = _

  @BeanProperty
  @Property(description = "The API key for BitBucket Cloud", label = "API key", password = true)
  var apiKey: String = _
}
