package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.domain.scm.connector.ScmConnectorConfig
import com.xebialabs.xlrelease.domain.utils.ScmException
import com.xebialabs.xlrelease.views.ConfigurationStatusResponse
import jakarta.ws.rs._
import jakarta.ws.rs.core.{MediaType, Response}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import scala.util.{Failure, Success, Using}

@Path("/scm")
@Produces(Array(MediaType.APPLICATION_JSON))
@Consumes(Array(MediaType.APPLICATION_JSON))
@Controller
class ScmConnectorResource @Autowired()() {

  @POST
  @Path("status")
  def status(scmConnectorConfig: ScmConnectorConfig): Response = {
    // todo resolve variables
    Using.resource(scmConnectorConfig.getConnector) { connector =>
      val result = connector.connectionStatus()
      result match {
        case Success(_) =>
          Response.ok(new ConfigurationStatusResponse(true, null)).build()
        case Failure(ex: ScmException) =>
          Response.ok(new ConfigurationStatusResponse(false, ex.getMessage)).build()
        case Failure(ex) =>
          Response.ok(new ConfigurationStatusResponse(false, ex.getMessage)).build()
      }
    }
  }
}
