package com.xebialabs.xlrelease.scm.connector;


import java.util.Optional;

public class GitConnectionSettings {
    private final String url;
    private final String branch;
    private final String authenticationMethod;
    private final String username;
    private final String password;
    private final String domain;
    private final String proxyHost;
    private final Integer proxyPort;
    private final String proxyUsername;
    private final String proxyPassword;
    private final String proxyDomain;
    private final String committerUsername;
    private final String committerEmail;

    public GitConnectionSettings(final String url,
                                 final String branch,
                                 final String authenticationMethod,
                                 final String username,
                                 final String password,
                                 final String domain,
                                 final String proxyHost,
                                 final String proxyPort,
                                 final String proxyUsername,
                                 final String proxyPassword,
                                 final String proxyDomain,
                                 final String committerUsername,
                                 final String committerEmail) {
        this.url = url;
        this.branch = branch;
        this.authenticationMethod = authenticationMethod;
        this.username = username;
        this.password = password;
        this.domain = domain;
        this.proxyHost = proxyHost;
        this.proxyPort = Optional.ofNullable(proxyPort)
                .filter(x -> !x.isEmpty())
                .map(Integer::parseInt)
                .orElse(-1);
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.proxyDomain = proxyDomain;
        this.committerUsername = committerUsername;
        this.committerEmail = committerEmail;
    }

    public String getUrl() {
        return url;
    }

    public String getBranch() {
        return branch;
    }

    public String getAuthenticationMethod() {
        return authenticationMethod;
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    public String getDomain() {
        return domain;
    }

    public String getProxyHost() {
        return proxyHost;
    }

    public Integer getProxyPort() {
        return proxyPort;
    }

    public String getProxyUsername() {
        return proxyUsername;
    }

    public String getProxyPassword() {
        return proxyPassword;
    }

    public String getProxyDomain() {
        return proxyDomain;
    }

    public boolean shouldUseAuthentication() {
        return getPassword() != null && !getPassword().isEmpty() && getAuthenticationMethod() != null;
    }

    public boolean shouldUseProxy() {
        return getProxyHost() != null && !getProxyHost().isEmpty();
    }

    public boolean shouldUseProxyAuthentication() {
        return getProxyUsername() != null && !getProxyUsername().isEmpty() && getProxyPassword() != null && !getProxyPassword().isEmpty();
    }

    public String getCommitterUsername() {
        return committerUsername;
    }

    public String getCommitterEmail() {
        return committerEmail;
    }

    public boolean shouldUseNtlmProxyAuthentication() {
        return getProxyDomain() != null && !getProxyDomain().isEmpty();
    }
}
