/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scm.connector;

import com.google.common.net.UrlEscapers;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.scm.connector.GitLabScmConnectorConfig;
import com.xebialabs.xlrelease.domain.utils.ScmException;
import com.xebialabs.xlrelease.scm.connector.GitLabCommit;
import com.xebialabs.xlrelease.scm.connector.GitLabCommitAction;
import com.xebialabs.xlrelease.scm.connector.GitLabCommitResponse;
import com.xebialabs.xlrelease.scm.connector.GitLabProjectResponse;
import com.xebialabs.xlrelease.scm.connector.HttpClientRequest$;
import com.xebialabs.xlrelease.scm.connector.RestApiScmConnector;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.scm.connector.ScmHttpClientWrapper;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo;
import java.io.Serializable;
import java.util.Base64;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\u0007\u000f\u0001eA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006O\u0001!\t\u0001\u000b\u0005\u0006W\u0001!\t\u0006\f\u0005\u0006s\u0001!\tF\u000f\u0005\u00065\u0002!\tf\u0017\u0005\u0006E\u0002!Ia\u0019\u0005\u0006I\u0002!I!\u001a\u0005\u0006_\u0002!I\u0001\u001d\u0005\b\u0003#\u0001A\u0011BA\n\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002>\u0001!I!a\u0010\u0003%\u001dKG\u000fT1c'\u000el7i\u001c8oK\u000e$xN\u001d\u0006\u0003\u001fA\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005E\u0011\u0012aA:d[*\u00111\u0003F\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0006\f\u0002\u0013a,'-[1mC\n\u001c(\"A\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001d\u001b\u0005q\u0011BA\u000f\u000f\u0005M\u0011Vm\u001d;Ba&\u001c6-\\\"p]:,7\r^8s\u0003\u0019\u0019wN\u001c4jOB\u0011\u0001%J\u0007\u0002C)\u0011qB\t\u0006\u0003#\rR!\u0001\n\n\u0002\r\u0011|W.Y5o\u0013\t1\u0013E\u0001\rHSRd\u0015MY*d[\u000e{gN\\3di>\u00148i\u001c8gS\u001e\fa\u0001P5oSRtDCA\u0015+!\tY\u0002\u0001C\u0003\u001f\u0005\u0001\u0007q$\u0001\buKN$(+\u001a9pg&$xN]=\u0016\u00035\u00022AL\u001a6\u001b\u0005y#B\u0001\u00192\u0003\u0011)H/\u001b7\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0018\u0003\u0007Q\u0013\u0018\u0010\u0005\u00027o5\t\u0011'\u0003\u00029c\t!QK\\5u\u00031\u0019w.\\7ji\u0006sG\rV1h)\u0011Yt\t\u0014+\u0011\u00079\u001aD\b\u0005\u0002>\t:\u0011aH\u0011\t\u0003\u007fEj\u0011\u0001\u0011\u0006\u0003\u0003b\ta\u0001\u0010:p_Rt\u0014BA\"2\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r\u000b\u0004\"\u0002%\u0005\u0001\u0004I\u0015!\u00022m_\n\u001c\bCA\u000eK\u0013\tYeB\u0001\u0005TG6\u0014En\u001c2t\u0011\u0015iE\u00011\u0001O\u0003)\u0019w.\\7ji&sgm\u001c\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#B\tA\u0001Z1uC&\u00111\u000b\u0015\u0002\u0014-\u0006d\u0017\u000eZ1uK\u0012\u001cu.\\7ji&sgm\u001c\u0005\u0006+\u0012\u0001\rAV\u0001\u0005kN,'\u000f\u0005\u0002X16\t1%\u0003\u0002ZG\tYQk]3s!J|g-\u001b7f\u00035!\u0018m\u001a(piB\u0013Xm]3oiR\u0011A\f\u0019\t\u0004]Mj\u0006C\u0001\u001c_\u0013\ty\u0016GA\u0004C_>dW-\u00198\t\u000b\u0005,\u0001\u0019\u0001\u001f\u0002\u0007Q\fw-\u0001\u0007de\u0016\fG/\u001a\"sC:\u001c\u0007\u000eF\u0001.\u00031\u0019'/Z1uK\u000e{W.\\5u)\t1'\u000eE\u0002/g\u001d\u0004\"a\u00075\n\u0005%t!\u0001F$ji2\u000b'mQ8n[&$(+Z:q_:\u001cX\rC\u0003l\u000f\u0001\u0007A.A\u0006sKF,Xm\u001d;C_\u0012L\bCA\u000en\u0013\tqgB\u0001\u0007HSRd\u0015MY\"p[6LG/A\u0005de\u0016\fG/\u001a+bOR)\u0011/!\u0003\u0002\u000eA\u0019af\r:\u0011\u0007MTH0D\u0001u\u0015\t)h/\u0001\u0003iiR\u0004(BA<y\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A=\u0002\u0007=\u0014x-\u0003\u0002|i\nq!+Z:q_:\u001cX-\u00128uSRL\bcA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\tA\u0001\\1oO*\u0011\u00111A\u0001\u0005U\u00064\u0018-C\u0002\u0002\by\u0014AAV8jI\"1\u00111\u0002\u0005A\u0002q\nq\u0001^1h\u001d\u0006lW\r\u0003\u0004\u0002\u0010!\u0001\r\u0001P\u0001\u0004g\"\f\u0017aF2sK\u0006$XMR5mKJ+\u0017/^3ti\u0006\u001bG/[8o)\u0011\t)\"a\f\u0011\t9\u001a\u0014q\u0003\t\u0007\u00033\t\u0019#!\u000b\u000f\t\u0005m\u0011q\u0004\b\u0004\u007f\u0005u\u0011\"\u0001\u001a\n\u0007\u0005\u0005\u0012'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0012q\u0005\u0002\u0004'\u0016\f(bAA\u0011cA\u00191$a\u000b\n\u0007\u00055bB\u0001\nHSRd\u0015MY\"p[6LG/Q2uS>t\u0007\"\u0002%\n\u0001\u0004I\u0015\u0001\u0003:fa>t\u0015-\\3\u0016\u0003q\n\u0011\"\u001e:m\u000b:\u001cw\u000eZ3\u0015\u0007q\nI\u0004\u0003\u0004\u0002<-\u0001\r\u0001P\u0001\u0006m\u0006dW/Z\u0001\u000eO&$H*\u00192SKF,Xm\u001d;\u0016\u0005\u0005\u0005\u0003cA\u000e\u0002D%\u0019\u0011Q\t\b\u0003)M\u001bW\u000e\u0013;ua\u000ec\u0017.\u001a8u/J\f\u0007\u000f]3s\u0001")
public class GitLabScmConnector
extends RestApiScmConnector {
    private final GitLabScmConnectorConfig config;

    @Override
    public Try<BoxedUnit> testRepository() {
        return this.gitLabRequest().get("/projects/" + this.repoName()).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable)x$1 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$1).tried()).map((Function1 & Serializable)x$2 -> {
            GitLabScmConnector.$anonfun$testRepository$2(x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Try<String> commitAndTag(ScmBlobs blobs, ValidatedCommitInfo commitInfo, UserProfile user) {
        return this.createBranch().flatMap((Function1 & Serializable)x$4 -> {
            BoxedUnit boxedUnit = x$4;
            return this.createFileRequestAction(blobs).flatMap((Function1 & Serializable)fileCommitAction -> Try$.MODULE$.apply((Function0 & Serializable)() -> new GitLabCommit($this.config.branch(), commitInfo.message(), CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)fileCommitAction).asJavaCollection())).flatMap((Function1 & Serializable)requestBody -> this.createCommit((GitLabCommit)requestBody).flatMap((Function1 & Serializable)gitCommitInfo -> this.createTag(commitInfo.tag().refName(), gitCommitInfo.id()).map((Function1 & Serializable)x$3 -> {
                ResponseEntity responseEntity = x$3;
                return gitCommitInfo.id();
            }))));
        });
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return this.gitLabRequest().get("/projects/" + this.repoName() + "/repository/tags/" + tag).doRequest(ClassTag$.MODULE$.apply(Void.class)).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GitLabScmConnector.$anonfun$tagNotPresent$1(x$5)));
    }

    private Try<BoxedUnit> createBranch() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ResponseEntity projectResponse = (ResponseEntity)this.gitLabRequest().get("/projects/" + this.repoName()).doRequest(ClassTag$.MODULE$.apply(GitLabProjectResponse.class)).get();
            if (!HttpClientRequest$.MODULE$.ResponseEntityExtension(projectResponse).isSuccessful()) {
                throw new ScmException("Unable to retrieve default branch", null, projectResponse.getStatusCode().value());
            }
            boolean exist = HttpClientRequest$.MODULE$.ResponseEntityExtension((ResponseEntity)this.gitLabRequest().get("/projects/" + this.repoName() + "/repository/branches/" + $this.config.branch()).doRequest(ClassTag$.MODULE$.apply(Void.class)).get()).isSuccessful();
            if (!exist) {
                ScmHttpClientWrapper qual$1 = this.gitLabRequest().addQueryParam("ref", ((GitLabProjectResponse)projectResponse.getBody()).default_branch()).addQueryParam("branch", $this.config.branch());
                String x$1 = "/projects/" + this.repoName() + "/repository/branches";
                Null$ x$2 = qual$1.post$default$2();
                ResponseEntity response = (ResponseEntity)qual$1.post(x$1, null).doRequest(ClassTag$.MODULE$.apply(Void.class)).get();
                if (!HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful()) {
                    throw new ScmException("Unable to create branch", null, response.getStatusCode().value());
                }
                return;
            }
        });
    }

    private Try<GitLabCommitResponse> createCommit(GitLabCommit requestBody) {
        return this.gitLabRequest().post("/projects/" + this.repoName() + "/repository/commits", requestBody).doRequest(ClassTag$.MODULE$.apply(GitLabCommitResponse.class)).flatMap((Function1 & Serializable)x$6 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$6).checkResponse("Error occured while trying to commit on GitLab")).map((Function1 & Serializable)x$7 -> (GitLabCommitResponse)x$7.getBody());
    }

    private Try<ResponseEntity<Void>> createTag(String tagName, String sha) {
        ScmHttpClientWrapper qual$1 = this.gitLabRequest().addQueryParam("tag_name", tagName).addQueryParam("ref", sha);
        String x$1 = "/projects/" + this.repoName() + "/repository/tags";
        Null$ x$2 = qual$1.post$default$2();
        return qual$1.post(x$1, null).doRequest(ClassTag$.MODULE$.apply(Void.class)).flatMap((Function1 & Serializable)x$8 -> HttpClientRequest$.MODULE$.ResponseEntityExtension(x$8).checkResponse("Error occurred while trying to create tag"));
    }

    private Try<Seq<GitLabCommitAction>> createFileRequestAction(ScmBlobs blobs) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ListBuffer actions = ListBuffer$.MODULE$.empty();
            blobs.filesToAdd().foreach((Function1 & Serializable)file -> {
                ResponseEntity response = (ResponseEntity)this.gitLabRequest().addQueryParam("ref", $this.config.branch()).get("/projects/" + this.repoName() + "/repository/files/" + this.urlEncode(file.absolutePath())).doRequest(ClassTag$.MODULE$.apply(Void.class)).get();
                HttpStatusCode httpStatusCode = response.getStatusCode();
                HttpStatus httpStatus = HttpStatus.UNAUTHORIZED;
                if (!(httpStatusCode != null ? !httpStatusCode.equals(httpStatus) : httpStatus != null)) {
                    throw new ScmException("Unable to connect to the repository.", null, response.getStatusCode().value());
                }
                if (HttpClientRequest$.MODULE$.ResponseEntityExtension(response).isSuccessful()) {
                    return (ListBuffer)actions.$plus$eq((Object)new GitLabCommitAction("update", file.absolutePath(), Base64.getEncoder().encodeToString((byte[])file.getContent().apply()), "base64"));
                }
                return (ListBuffer)actions.$plus$eq((Object)new GitLabCommitAction("create", file.absolutePath(), Base64.getEncoder().encodeToString((byte[])file.getContent().apply()), "base64"));
            });
            return actions.toSeq();
        });
    }

    private String repoName() {
        return this.urlEncode(this.config.repository());
    }

    private String urlEncode(String value) {
        return UrlEscapers.urlPathSegmentEscaper().escape(value);
    }

    private ScmHttpClientWrapper gitLabRequest() {
        return HttpClientRequest$.MODULE$.newRequest(this.config.restApiUrl()).setUriEncoded(true).withAuth(this.config.credential());
    }

    public static final /* synthetic */ void $anonfun$testRepository$2(Void x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$tagNotPresent$1(ResponseEntity x$5) {
        HttpStatusCode httpStatusCode = x$5.getStatusCode();
        HttpStatus httpStatus = HttpStatus.NOT_FOUND;
        return !(httpStatusCode != null ? !httpStatusCode.equals(httpStatus) : httpStatus != null);
    }

    public GitLabScmConnector(GitLabScmConnectorConfig config) {
        this.config = config;
        super(config);
    }
}

