package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.internal.views.ExternalDeploymentOrderDirection;
import com.xebialabs.xlrelease.api.internal.views.ExternalDeploymentOrderMode;
import com.xebialabs.xlrelease.api.internal.views.ExternalDeploymentView;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

@Path("/external-deployment")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface ExternalDeploymentApi extends ApiService {

    default String serviceName() {
        return "externalDeploymentApi";
    }

    @GET
    ExternalDeploymentView getExternalDeployments(
            @QueryParam("folderId") String folderId,
            @DefaultValue("0") @QueryParam("max-age") Long maxAge,
            @DefaultValue("0") @QueryParam(PAGE) Long page,
            @DefaultValue("100") @QueryParam(RESULTS_PER_PAGE) Long resultsPerPage,
            @DefaultValue("STATUS") @QueryParam(ORDER_BY) ExternalDeploymentOrderMode orderBy,
            @DefaultValue("ASC") @QueryParam("order") ExternalDeploymentOrderDirection direction
    );

}
