package com.xebialabs.xlrelease.api.internal

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.api.internal.views.{ExternalDeploymentOrderDirection, ExternalDeploymentOrderMode, ExternalDeploymentView}
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.status.service.EndpointExternalDeploymentService
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource
import org.springframework.stereotype.Controller

import java.lang
import scala.jdk.CollectionConverters._

@Controller
class ExternalDeploymentApiImpl(
                                externalDeploymentService: EndpointExternalDeploymentService,
                                configurationRepository: ConfigurationRepository
                              ) extends  ExternalDeploymentApi {
  override def getExternalDeployments(
                                       folderId: String,
                                       maxAge: lang.Long,
                                       page: lang.Long,
                                       resultsPerPage: lang.Long,
                                       orderBy: ExternalDeploymentOrderMode,
                                       direction: ExternalDeploymentOrderDirection
                                     ): ExternalDeploymentView = {
    val endpointIds = configurationRepository
      .findAllByTypeAndTitle[StatusWebhookEventSource](Type.valueOf(classOf[StatusWebhookEventSource]), null, folderId, true)
      .asScala.map(_.getId).toVector
    externalDeploymentService.getExternalDeployment(endpointIds, maxAge, page, resultsPerPage, orderBy, direction)
  }
}
